/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    private RandomUtils() {
    }

    public static long nextLongInclusive(long upperBound) {
        return RandomUtils.nextLongInclusive(0L, upperBound);
    }

    public static long nextLongInclusive(long lowerBound, long upperBound) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("Lower bound cannot be greater than upper bound.");
        }
        if (upperBound == lowerBound) {
            return upperBound;
        }
        if (upperBound != Long.MAX_VALUE) {
            return ThreadLocalRandom.current().nextLong(lowerBound, upperBound + 1L);
        }
        if (lowerBound == Long.MIN_VALUE) {
            return ThreadLocalRandom.current().nextLong();
        }
        return ThreadLocalRandom.current().nextLong(lowerBound - 1L, Long.MAX_VALUE) + 1L;
    }
}

