/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

import io.servicetalk.utils.internal.ReflectionUtils;
import java.io.FileDescriptor;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PlatformDependent0 {
    private static final Logger LOGGER;
    private static final boolean IS_EXPLICIT_NO_UNSAFE;
    private static final String DEALLOCATOR_CLASS_NAME = "java.nio.DirectByteBuffer$Deallocator";
    @Deprecated
    @Nullable
    private static final Object UNSAFE;
    @Nullable
    private static final MethodHandle DIRECT_BUFFER_CONSTRUCTOR;
    @Nullable
    private static final MethodHandle DEALLOCATOR_CONSTRUCTOR;
    @Nullable
    private static final MethodHandle RESERVE_MEMORY;
    @Nullable
    private static final MethodHandle UNRESERVE_MEMORY;
    @Nullable
    private static final MethodHandle ALLOCATE_MEMORY;
    @Nullable
    private static final MethodHandle FREE_MEMORY;
    @Nullable
    private static final Consumer<Throwable> THROW_EXCEPTION;
    private static final boolean USE_DIRECT_BUFFER_WITHOUT_ZEROING;
    private static final Object DUMMY;

    private PlatformDependent0() {
    }

    @Deprecated
    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static boolean useDirectBufferWithoutZeroing() {
        return USE_DIRECT_BUFFER_WITHOUT_ZEROING;
    }

    static void reserveMemory(long size, int capacity) {
        assert (RESERVE_MEMORY != null);
        try {
            RESERVE_MEMORY.invoke(size, capacity);
        }
        catch (Throwable t) {
            PlatformDependent0.throwException(t);
        }
    }

    static void unreserveMemory(long size, int capacity) {
        assert (UNRESERVE_MEMORY != null);
        try {
            UNRESERVE_MEMORY.invoke(size, capacity);
        }
        catch (Throwable t) {
            PlatformDependent0.throwException(t);
        }
    }

    static long allocateMemory(long size) {
        assert (ALLOCATE_MEMORY != null);
        try {
            return ALLOCATE_MEMORY.invokeExact(size);
        }
        catch (Throwable t) {
            PlatformDependent0.throwException(t);
            return Long.MIN_VALUE;
        }
    }

    static void freeMemory(long address) {
        assert (FREE_MEMORY != null);
        try {
            FREE_MEMORY.invokeExact(address);
        }
        catch (Throwable t) {
            PlatformDependent0.throwException(t);
        }
    }

    static ByteBuffer newDirectBuffer(long address, long size, int capacity) {
        assert (DEALLOCATOR_CONSTRUCTOR != null);
        assert (DIRECT_BUFFER_CONSTRUCTOR != null);
        try {
            Runnable deallocator = DEALLOCATOR_CONSTRUCTOR.invoke(address, size, capacity);
            return DIRECT_BUFFER_CONSTRUCTOR.invoke(capacity, address, null, deallocator);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable cause) {
            throw new Error(cause);
        }
    }

    static <T> T throwException(Throwable t) {
        THROW_EXCEPTION.accept(Objects.requireNonNull(t));
        return PlatformDependent0.uncheckedCast();
    }

    private static <E extends Throwable> void throwException0(Throwable t) throws E {
        throw t;
    }

    private static <T> T uncheckedCast() {
        return (T)DUMMY;
    }

    static {
        ByteBuffer direct;
        MethodHandles.Lookup lookup;
        Object unsafe;
        LOGGER = LoggerFactory.getLogger(PlatformDependent0.class);
        IS_EXPLICIT_NO_UNSAFE = Boolean.getBoolean("io.servicetalk.noUnsafe");
        DUMMY = new Object();
        if (IS_EXPLICIT_NO_UNSAFE) {
            unsafe = null;
        } else {
            Object maybeUnsafe = AccessController.doPrivileged(() -> {
                try {
                    Field unsafeField = Class.forName("sun.misc.Unsafe").getDeclaredField("theUnsafe");
                    Throwable cause = ReflectionUtils.trySetAccessible(unsafeField, false);
                    if (cause != null) {
                        return cause;
                    }
                    return unsafeField.get(null);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
                    return e;
                }
            });
            if (maybeUnsafe instanceof Throwable) {
                unsafe = null;
                LOGGER.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Throwable)maybeUnsafe);
            } else {
                unsafe = maybeUnsafe;
                LOGGER.debug("sun.misc.Unsafe.theUnsafe: available");
            }
        }
        if (null == unsafe) {
            lookup = null;
            THROW_EXCEPTION = PlatformDependent0::throwException0;
            ALLOCATE_MEMORY = null;
            FREE_MEMORY = null;
            UNSAFE = null;
        } else {
            lookup = MethodHandles.lookup();
            Consumer throwConsumer = PlatformDependent0::throwException0;
            MethodHandle throwExceptionMH = null;
            MethodHandle allocateMH = null;
            MethodHandle freeMH = null;
            try {
                throwExceptionMH = lookup.findVirtual(unsafe.getClass(), "throwException", MethodType.methodType(Void.TYPE, Throwable.class));
                CallSite throwExceptionCallSite = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(Consumer.class, unsafe.getClass()), MethodType.methodType(Void.TYPE, Object.class), throwExceptionMH, MethodType.methodType(Void.TYPE, Throwable.class));
                throwConsumer = throwExceptionCallSite.getTarget().bindTo(unsafe).invoke();
                LOGGER.debug("sun.misc.Unsafe#throwException(Throwable): available");
            }
            catch (Throwable t) {
                LOGGER.debug("sun.misc.Unsafe#throwException(Throwable): unavailable", t);
            }
            Long address = null;
            try {
                allocateMH = lookup.findVirtual(unsafe.getClass(), "allocateMemory", MethodType.methodType(Long.TYPE, Long.TYPE)).bindTo(unsafe);
                address = allocateMH.invokeExact(1L);
                LOGGER.debug("sun.misc.Unsafe#allocateMemory(long): available");
            }
            catch (Throwable t) {
                LOGGER.debug("sun.misc.Unsafe#allocateMemory(long): unavailable", t);
            }
            try {
                freeMH = lookup.findVirtual(unsafe.getClass(), "freeMemory", MethodType.methodType(Void.TYPE, Long.TYPE)).bindTo(unsafe);
                if (address != null) {
                    freeMH.invokeExact(address);
                }
                LOGGER.debug("sun.misc.Unsafe#freeMemory(long): available");
            }
            catch (Throwable t) {
                LOGGER.debug("sun.misc.Unsafe#freeMemory(long): unavailable", t);
            }
            THROW_EXCEPTION = throwConsumer;
            ALLOCATE_MEMORY = allocateMH;
            FREE_MEMORY = freeMH;
            UNSAFE = THROW_EXCEPTION != null && ALLOCATE_MEMORY != null && FREE_MEMORY != null ? unsafe : null;
        }
        LOGGER.debug("sun.misc.Unsafe: {}", (Object)(UNSAFE != null ? "available" : "unavailable"));
        if (UNSAFE == null) {
            direct = null;
            DIRECT_BUFFER_CONSTRUCTOR = null;
        } else {
            direct = ByteBuffer.allocateDirect(1);
            DIRECT_BUFFER_CONSTRUCTOR = ReflectionUtils.lookupAccessibleObject(() -> direct.getClass().getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class), Constructor.class, constructor -> {
                long address = 0L;
                try {
                    MethodHandle methodHandle = lookup.unreflectConstructor((Constructor<?>)constructor);
                    address = PlatformDependent0.allocateMemory(1L);
                    if (methodHandle.invoke(1, address, null, () -> {}) instanceof ByteBuffer) {
                        MethodHandle methodHandle2 = methodHandle;
                        return methodHandle2;
                    }
                    MethodHandle methodHandle3 = null;
                    return methodHandle3;
                }
                finally {
                    if (address != 0L) {
                        PlatformDependent0.freeMemory(address);
                    }
                }
            });
        }
        LOGGER.debug("java.nio.DirectByteBuffer.<init>(int, long, FileDescriptor, Runnable): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
        DEALLOCATOR_CONSTRUCTOR = UNSAFE == null || DIRECT_BUFFER_CONSTRUCTOR == null ? null : ReflectionUtils.lookupAccessibleObject(() -> {
            for (Class<?> innerClass : direct.getClass().getDeclaredClasses()) {
                if (!DEALLOCATOR_CLASS_NAME.equals(innerClass.getName())) continue;
                return innerClass.getDeclaredConstructor(Long.TYPE, Long.TYPE, Integer.TYPE);
            }
            return null;
        }, Constructor.class, constructor -> {
            MethodHandle methodHandle = lookup.unreflectConstructor((Constructor<?>)constructor);
            if (methodHandle.invoke(0L, 0L, 0) instanceof Runnable) {
                return methodHandle;
            }
            return null;
        });
        LOGGER.debug("java.nio.DirectByteBuffer$Deallocator.<init>(long, long, int): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
        if (UNSAFE == null || DIRECT_BUFFER_CONSTRUCTOR == null || DEALLOCATOR_CONSTRUCTOR == null) {
            RESERVE_MEMORY = null;
            UNRESERVE_MEMORY = null;
        } else {
            RESERVE_MEMORY = ReflectionUtils.extractNioBitsMethod("reserveMemory", lookup);
            UNRESERVE_MEMORY = ReflectionUtils.extractNioBitsMethod("unreserveMemory", lookup);
        }
        LOGGER.debug("java.nio.Bits.reserveMemory(long, int): {}", (Object)(RESERVE_MEMORY != null ? "available" : "unavailable"));
        LOGGER.debug("java.nio.Bits.unreserveMemory(long, int): {}", (Object)(UNRESERVE_MEMORY != null ? "available" : "unavailable"));
        USE_DIRECT_BUFFER_WITHOUT_ZEROING = UNSAFE != null && DIRECT_BUFFER_CONSTRUCTOR != null && DEALLOCATOR_CONSTRUCTOR != null && RESERVE_MEMORY != null && UNRESERVE_MEMORY != null && ALLOCATE_MEMORY != null && FREE_MEMORY != null;
        LOGGER.debug("Allocation of DirectByteBuffer without zeroing memory: {}", (Object)(USE_DIRECT_BUFFER_WITHOUT_ZEROING ? "available" : "unavailable"));
    }
}

