/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static int ensurePositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(name + ": " + value + " (expected > 0)");
        }
        return value;
    }

    public static long ensurePositive(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(name + ": " + value + " (expected > 0)");
        }
        return value;
    }

    public static int ensureNonNegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + ": " + value + " (expected >= 0)");
        }
        return value;
    }

    public static long ensureNonNegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + ": " + value + " (expected >= 0)");
        }
        return value;
    }
}

