/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent;

import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.BlockingSpliterator;
import io.servicetalk.concurrent.CloseableIterable;
import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.SpliteratorToBlockingSpliterator;
import io.servicetalk.concurrent.ThrowableUtils;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;

public interface BlockingIterable<T>
extends CloseableIterable<T> {
    @Override
    public BlockingIterator<T> iterator();

    @Override
    default public void forEach(Consumer<? super T> action) {
        try (CloseableIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                action.accept(iterator.next());
            }
        }
        catch (Throwable t) {
            ThrowableUtils.sneakyThrow(t);
        }
    }

    default public void forEach(Consumer<? super T> action, LongSupplier timeoutSupplier, TimeUnit unit) throws TimeoutException {
        Objects.requireNonNull(action);
        try (CloseableIterator iterator = this.iterator();){
            while (iterator.hasNext(timeoutSupplier.getAsLong(), unit)) {
                action.accept(iterator.next(timeoutSupplier.getAsLong(), unit));
            }
        }
        catch (Throwable t) {
            ThrowableUtils.sneakyThrow(t);
        }
    }

    default public void forEach(Consumer<? super T> action, long timeout, TimeUnit unit) throws TimeoutException {
        Objects.requireNonNull(action);
        try (CloseableIterator iterator = this.iterator();){
            long remainingTimeoutNanos = unit.toNanos(timeout);
            long timeStampANanos = System.nanoTime();
            while (iterator.hasNext(remainingTimeoutNanos, TimeUnit.NANOSECONDS)) {
                long timeStampBNanos = System.nanoTime();
                action.accept(iterator.next(remainingTimeoutNanos -= timeStampBNanos - timeStampANanos, TimeUnit.NANOSECONDS));
                timeStampANanos = System.nanoTime();
                remainingTimeoutNanos -= timeStampANanos - timeStampBNanos;
            }
        }
        catch (Throwable t) {
            ThrowableUtils.sneakyThrow(t);
        }
    }

    @Override
    default public BlockingSpliterator<T> spliterator() {
        CloseableIterator iterator = this.iterator();
        return new SpliteratorToBlockingSpliterator(iterator, Spliterators.spliteratorUnknownSize(iterator, 0));
    }

    public static interface Processor<T>
    extends BlockingIterable<T>,
    AutoCloseable {
        public void next(@Nullable T var1) throws Exception;

        public void fail(Throwable var1) throws Exception;

        @Override
        public void close() throws Exception;
    }
}

