/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class FutureUtils {
    private FutureUtils() {
    }

    public static void awaitTermination(Future<Void> future) {
        FutureUtils.awaitResult(future);
    }

    public static <T> T awaitResult(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return (T)ThrowableUtils.throwException((Throwable)e);
        }
        catch (ExecutionException e) {
            return (T)ThrowableUtils.throwException((Throwable)e.getCause());
        }
    }
}

