/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.LongBinaryConsumer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nullable;

final class ValidateDemandPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final ObjLongConsumer<T> onNextConsumer;
    private final LongBinaryConsumer requestConsumer;

    ValidateDemandPublisher(Publisher<T> original, ObjLongConsumer<T> onNextConsumer, LongBinaryConsumer requestConsumer) {
        super(original);
        this.onNextConsumer = Objects.requireNonNull(onNextConsumer);
        this.requestConsumer = Objects.requireNonNull(requestConsumer);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new ValidateDemandSubscriber(this, subscriber);
    }

    private static final class ValidateDemandSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private static final AtomicLongFieldUpdater<ValidateDemandSubscriber> demandUpdater = AtomicLongFieldUpdater.newUpdater(ValidateDemandSubscriber.class, "demand");
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final ValidateDemandPublisher<T> parent;
        private volatile long demand;

        private ValidateDemandSubscriber(ValidateDemandPublisher<T> parent, PublisherSource.Subscriber<? super T> subscriber) {
            this.parent = parent;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        public void onSubscribe(final PublisherSource.Subscription subscription) {
            this.subscriber.onSubscribe(new PublisherSource.Subscription(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void request(long n) {
                    try {
                        if (SubscriberUtils.isRequestNValid((long)n)) {
                            long currDemand = demandUpdater.accumulateAndGet(this, n, FlowControlUtils::addWithOverflowProtection);
                            parent.requestConsumer.accept(n, currDemand);
                        }
                    }
                    finally {
                        subscription.request(n);
                    }
                }

                public void cancel() {
                    subscription.cancel();
                }
            });
        }

        public void onNext(@Nullable T t) {
            long currDemand = demandUpdater.decrementAndGet(this);
            ((ValidateDemandPublisher)this.parent).onNextConsumer.accept(t, currDemand);
            if (currDemand < 0L) {
                throw new IllegalStateException("Received onNext signal='" + t + "' with no demand");
            }
            this.subscriber.onNext(t);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

