/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CancelPropagatingCompletableFuture;
import io.servicetalk.concurrent.api.NonBlockingThreadUtils;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class SingleToCompletableFuture<T>
extends CompletableFuture<T>
implements SingleSource.Subscriber<T> {
    private final SequentialCancellable cancellable = new SequentialCancellable();

    private SingleToCompletableFuture() {
    }

    static <X> CompletableFuture<X> createAndSubscribe(Single<X> original) {
        SingleToCompletableFuture future = new SingleToCompletableFuture();
        AsyncContextProvider provider = AsyncContext.provider();
        return provider.wrapCompletableFuture(future, original.subscribeAndReturnContext(future, provider));
    }

    private void disableCancellable() {
        this.cancellable.nextCancellable(Cancellable.IGNORE_CANCEL);
    }

    public void onSubscribe(Cancellable cancellable) {
        this.cancellable.nextCancellable(cancellable);
    }

    public void onSuccess(@Nullable T result) {
        this.disableCancellable();
        super.complete(result);
    }

    public void onError(Throwable t) {
        this.disableCancellable();
        super.completeExceptionally(t);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenApply((Function)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenApplyAsync((Function)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenApplyAsync((Function)fn, executor), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenAccept((Consumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenAcceptAsync((Consumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenAcceptAsync((Consumer)action, executor), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenRun(action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenRunAsync(action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenRunAsync(action, executor), (Cancellable)this.cancellable);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenCombine((CompletionStage)other, (BiFunction)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenCombineAsync((CompletionStage)other, (BiFunction)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenCombineAsync((CompletionStage)other, (BiFunction)fn, executor), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenAcceptBoth((CompletionStage)other, (BiConsumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, executor), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.runAfterBoth((CompletionStage)other, action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.runAfterBothAsync((CompletionStage)other, action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.runAfterBothAsync((CompletionStage)other, action, executor), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.applyToEither((CompletionStage)other, (Function)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.applyToEitherAsync((CompletionStage)other, (Function)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.applyToEitherAsync((CompletionStage)other, (Function)fn, executor), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.acceptEither((CompletionStage)other, (Consumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.acceptEitherAsync((CompletionStage)other, (Consumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.runAfterEither((CompletionStage)other, action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.runAfterEitherAsync((CompletionStage)other, action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.runAfterEitherAsync((CompletionStage)other, action, executor), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenCompose((Function)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenComposeAsync((Function)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.thenComposeAsync((Function)fn, executor), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.exceptionally((Function)fn), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.whenComplete((BiConsumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.whenCompleteAsync((BiConsumer)action), (Cancellable)this.cancellable);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.whenCompleteAsync((BiConsumer)action, executor), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.handle((BiFunction)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.handleAsync((BiFunction)fn), (Cancellable)this.cancellable);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return CancelPropagatingCompletableFuture.newCancelPropagatingFuture(super.handleAsync((BiFunction)fn, executor), (Cancellable)this.cancellable);
    }

    @Override
    public boolean complete(T value) {
        try {
            boolean bl = super.complete(value);
            return bl;
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        try {
            boolean bl = super.completeExceptionally(ex);
            return bl;
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public void obtrudeValue(T value) {
        try {
            super.obtrudeValue(value);
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public void obtrudeException(Throwable ex) {
        try {
            super.obtrudeException(ex);
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean bl = super.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.cancellable.cancel();
        }
    }

    @Override
    @Nullable
    public T get() throws InterruptedException, ExecutionException {
        NonBlockingThreadUtils.checkNonBlockingThread(this.isDone());
        return super.get();
    }

    @Override
    @Nullable
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        NonBlockingThreadUtils.checkNonBlockingThread(this.isDone());
        return super.get(timeout, unit);
    }

    @Override
    @Nullable
    public T join() {
        NonBlockingThreadUtils.checkNonBlockingThread(this.isDone());
        return super.join();
    }
}

