/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class SingleFlatMapCompletable<T>
extends AbstractNoHandleSubscribeCompletable {
    private final Single<T> original;
    private final Function<? super T, ? extends Completable> nextFactory;

    SingleFlatMapCompletable(Single<T> original, Function<? super T, ? extends Completable> nextFactory) {
        this.original = Objects.requireNonNull(original);
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(CompletableSource.Subscriber subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new SubscriberImpl<T>(subscriber, this.nextFactory, capturedContext, contextProvider), capturedContext, contextProvider);
    }

    private static final class SubscriberImpl<T>
    implements SingleSource.Subscriber<T>,
    CompletableSource.Subscriber {
        private final CompletableSource.Subscriber subscriber;
        private final Function<T, ? extends Completable> nextFactory;
        private final CapturedContext capturedContext;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialCancellable sequentialCancellable;

        SubscriberImpl(CompletableSource.Subscriber subscriber, Function<T, ? extends Completable> nextFactory, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.nextFactory = nextFactory;
            this.capturedContext = capturedContext;
            this.contextProvider = contextProvider;
        }

        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.subscriber.onSubscribe((Cancellable)this.sequentialCancellable);
            } else {
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void onSuccess(@Nullable T result) {
            Completable next;
            try {
                next = Objects.requireNonNull(this.nextFactory.apply(result), () -> "Mapper " + this.nextFactory + " returned null");
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            next.subscribeInternal(this.contextProvider.wrapCompletableSubscriber(this, this.capturedContext));
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }
    }
}

