/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractPublisherGroupBy;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.GroupedPublisher;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class PublisherGroupToMany<Key, T>
extends AbstractPublisherGroupBy<Key, T> {
    private final Function<? super T, ? extends Iterator<? extends Key>> keySelector;

    PublisherGroupToMany(Publisher<T> original, Function<? super T, ? extends Iterator<? extends Key>> keySelector, int queueLimit) {
        super(original, queueLimit);
        this.keySelector = Objects.requireNonNull(keySelector);
    }

    PublisherGroupToMany(Publisher<T> original, Function<? super T, ? extends Iterator<? extends Key>> keySelector, int queueLimit, int expectedGroupCountHint) {
        super(original, queueLimit, expectedGroupCountHint);
        this.keySelector = Objects.requireNonNull(keySelector);
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super GroupedPublisher<Key, T>> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new GroupBySubscriber(subscriber, this.queueLimit, this.initialCapacityForGroups, capturedContext, contextProvider), capturedContext, contextProvider);
    }

    private final class GroupBySubscriber
    extends AbstractPublisherGroupBy.AbstractGroupBySubscriber<Key, T> {
        GroupBySubscriber(PublisherSource.Subscriber<? super GroupedPublisher<Key, T>> target, int maxQueueSize, int initialCapacityForGroups, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            super(target, maxQueueSize, initialCapacityForGroups, capturedContext, contextProvider);
        }

        public void onNext(@Nullable T t) {
            Iterator keys = Objects.requireNonNull((Iterator)PublisherGroupToMany.this.keySelector.apply(t), () -> "Selector " + PublisherGroupToMany.this.keySelector + " returned null");
            keys.forEachRemaining(key -> this.onNext(key, t));
        }
    }
}

