/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;

final class PublisherDoOnUtils {
    private PublisherDoOnUtils() {
    }

    static <X> Supplier<PublisherSource.Subscriber<? super X>> doOnSubscribeSupplier(final Consumer<? super PublisherSource.Subscription> onSubscribe) {
        Objects.requireNonNull(onSubscribe);
        PublisherSource.Subscriber subscriber = new PublisherSource.Subscriber<X>(){

            public void onSubscribe(PublisherSource.Subscription s) {
                onSubscribe.accept(s);
            }

            public void onNext(X t) {
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
            }
        };
        return () -> PublisherDoOnUtils.lambda$doOnSubscribeSupplier$0((PublisherSource.Subscriber)subscriber);
    }

    static <X> Supplier<PublisherSource.Subscriber<? super X>> doOnNextSupplier(final Consumer<X> onNext) {
        Objects.requireNonNull(onNext);
        PublisherSource.Subscriber subscriber = new PublisherSource.Subscriber<X>(){

            public void onSubscribe(PublisherSource.Subscription s) {
            }

            public void onNext(X t) {
                onNext.accept(t);
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
            }
        };
        return () -> PublisherDoOnUtils.lambda$doOnNextSupplier$1((PublisherSource.Subscriber)subscriber);
    }

    static <X> Supplier<PublisherSource.Subscriber<? super X>> doOnErrorSupplier(final Consumer<Throwable> onError) {
        Objects.requireNonNull(onError);
        PublisherSource.Subscriber subscriber = new PublisherSource.Subscriber<X>(){

            public void onSubscribe(PublisherSource.Subscription s) {
            }

            public void onNext(X t) {
            }

            public void onError(Throwable t) {
                onError.accept(t);
            }

            public void onComplete() {
            }
        };
        return () -> PublisherDoOnUtils.lambda$doOnErrorSupplier$2((PublisherSource.Subscriber)subscriber);
    }

    static <X> Supplier<PublisherSource.Subscriber<? super X>> doOnCompleteSupplier(final Runnable onComplete) {
        Objects.requireNonNull(onComplete);
        PublisherSource.Subscriber subscriber = new PublisherSource.Subscriber<X>(){

            public void onSubscribe(PublisherSource.Subscription s) {
            }

            public void onNext(X t) {
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
                onComplete.run();
            }
        };
        return () -> PublisherDoOnUtils.lambda$doOnCompleteSupplier$3((PublisherSource.Subscriber)subscriber);
    }

    static Supplier<PublisherSource.Subscription> doOnRequestSupplier(final LongConsumer onRequest) {
        Objects.requireNonNull(onRequest);
        PublisherSource.Subscription subscription = new PublisherSource.Subscription(){

            public void request(long n) {
                onRequest.accept(n);
            }

            public void cancel() {
            }
        };
        return () -> subscription;
    }

    static Supplier<PublisherSource.Subscription> doOnCancelSupplier(final Runnable onCancel) {
        Objects.requireNonNull(onCancel);
        PublisherSource.Subscription subscription = new PublisherSource.Subscription(){

            public void request(long n) {
            }

            public void cancel() {
                onCancel.run();
            }
        };
        return () -> subscription;
    }

    private static /* synthetic */ PublisherSource.Subscriber lambda$doOnCompleteSupplier$3(PublisherSource.Subscriber subscriber) {
        return subscriber;
    }

    private static /* synthetic */ PublisherSource.Subscriber lambda$doOnErrorSupplier$2(PublisherSource.Subscriber subscriber) {
        return subscriber;
    }

    private static /* synthetic */ PublisherSource.Subscriber lambda$doOnNextSupplier$1(PublisherSource.Subscriber subscriber) {
        return subscriber;
    }

    private static /* synthetic */ PublisherSource.Subscriber lambda$doOnSubscribeSupplier$0(PublisherSource.Subscriber subscriber) {
        return subscriber;
    }
}

