/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class OnErrorResumeSingle<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Single<T> original;
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Single<? extends T>> nextFactory;

    OnErrorResumeSingle(Single<T> original, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Single<? extends T>> nextFactory) {
        this.original = original;
        this.predicate = Objects.requireNonNull(predicate);
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ResumeSubscriber(subscriber, capturedContext, contextProvider), capturedContext, contextProvider);
    }

    private final class ResumeSubscriber
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> subscriber;
        private final CapturedContext capturedContext;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        private boolean resubscribed;

        ResumeSubscriber(SingleSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.capturedContext = capturedContext;
            this.contextProvider = contextProvider;
        }

        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.subscriber.onSubscribe((Cancellable)this.sequentialCancellable);
            } else {
                this.resubscribed = true;
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        public void onSuccess(@Nullable T result) {
            this.subscriber.onSuccess(result);
        }

        public void onError(Throwable throwable) {
            Single next;
            try {
                next = !this.resubscribed && OnErrorResumeSingle.this.predicate.test(throwable) ? Objects.requireNonNull((Single)OnErrorResumeSingle.this.nextFactory.apply(throwable)) : null;
            }
            catch (Throwable t) {
                this.subscriber.onError(ThrowableUtils.addSuppressed((Throwable)t, (Throwable)throwable));
                return;
            }
            if (next == null) {
                this.subscriber.onError(throwable);
            } else {
                SingleSource.Subscriber wrappedSubscriber = this.contextProvider.wrapSingleSubscriber(this, this.capturedContext);
                next.subscribeInternal(wrappedSubscriber);
            }
        }
    }
}

