/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.NonBlockingThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NonBlockingThreadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonBlockingThreadUtils.class);
    private static final String WARN_ON_NON_BLOCKING_THREAD_PROPERTY = "io.servicetalk.concurrent.api.warnOnNonBlockingThread";
    private static final boolean WARN_ON_NON_BLOCKING_THREAD = Boolean.getBoolean("io.servicetalk.concurrent.api.warnOnNonBlockingThread");

    private NonBlockingThreadUtils() {
    }

    static void checkNonBlockingThread(boolean done) {
        if (done) {
            return;
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof NonBlockingThread) {
            NonBlockingThread.IllegalBlockingOperationException e = new NonBlockingThread.IllegalBlockingOperationException("Not allowed to block a NonBlockingThread: " + thread);
            if (WARN_ON_NON_BLOCKING_THREAD) {
                LOGGER.warn("Not allowed to block a NonBlockingThread: {}", (Object)thread, (Object)e);
            } else {
                throw e;
            }
        }
    }

    static {
        if (WARN_ON_NON_BLOCKING_THREAD) {
            LOGGER.warn("-D{}: {}. Setting this property to 'true' may be used temporarily to unblock deployment but exposes the service to the risk of deadlocks or increased I/O latencies which can be very difficult to diagnose.", (Object)WARN_ON_NON_BLOCKING_THREAD_PROPERTY, (Object)WARN_ON_NON_BLOCKING_THREAD);
        } else {
            LOGGER.debug("-D{}: {}", (Object)WARN_ON_NON_BLOCKING_THREAD_PROPERTY, (Object)WARN_ON_NON_BLOCKING_THREAD);
        }
    }
}

