/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.DelegatingExecutor;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GlobalExecutor
extends DelegatingExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExecutor.class);
    static final String NAME_PREFIX = "servicetalk-global-executor";
    static final Executor GLOBAL_EXECUTOR = new GlobalExecutor(Executors.newCachedThreadExecutor(new DefaultThreadFactory("servicetalk-global-executor")));

    private GlobalExecutor(Executor delegate) {
        super(delegate);
    }

    @Override
    public Completable closeAsync() {
        return this.delegate().closeAsync().beforeOnSubscribe(__ -> GlobalExecutor.log(LOGGER, NAME_PREFIX, "closeAsync()"));
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.delegate().closeAsyncGracefully().beforeOnSubscribe(__ -> GlobalExecutor.log(LOGGER, NAME_PREFIX, "closeAsyncGracefully()"));
    }

    private static void log(Logger logger, String name, String methodName) {
        logger.info("Closure of \"{}\" was initiated using {} method. Closing the global instance before closing all resources that use it may result in unexpected behavior.", new Object[]{name, methodName, new Throwable("Stack trace")});
    }
}

