/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.ContextPreservingBiConsumer;
import io.servicetalk.concurrent.api.ContextPreservingBiFunction;
import io.servicetalk.concurrent.api.ContextPreservingCallable;
import io.servicetalk.concurrent.api.ContextPreservingCompletableFuture;
import io.servicetalk.concurrent.api.ContextPreservingCompletableSubscriber;
import io.servicetalk.concurrent.api.ContextPreservingConsumer;
import io.servicetalk.concurrent.api.ContextPreservingExecutor;
import io.servicetalk.concurrent.api.ContextPreservingExecutorService;
import io.servicetalk.concurrent.api.ContextPreservingFunction;
import io.servicetalk.concurrent.api.ContextPreservingRunnable;
import io.servicetalk.concurrent.api.ContextPreservingScheduledExecutorService;
import io.servicetalk.concurrent.api.ContextPreservingSingleSubscriber;
import io.servicetalk.concurrent.api.ContextPreservingStExecutor;
import io.servicetalk.concurrent.api.ContextPreservingSubscriber;
import io.servicetalk.concurrent.api.CopyOnWriteContextMap;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultAsyncContextProvider
implements AsyncContextProvider {
    private static final ThreadLocal<ContextMap> CONTEXT_THREAD_LOCAL = ThreadLocal.withInitial(DefaultAsyncContextProvider::newContextMap);
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncContextProvider.class);
    static final AsyncContextProvider INSTANCE = new DefaultAsyncContextProvider();
    private static final boolean NO_DEBUG_LOGGING = DefaultAsyncContextProvider.isNoDebugLogging();

    protected DefaultAsyncContextProvider() {
    }

    @Override
    public final ContextMap context() {
        Thread t = Thread.currentThread();
        if (t instanceof ContextMapHolder) {
            ContextMapHolder contextMapHolder = (ContextMapHolder)t;
            ContextMap map = contextMapHolder.context();
            if (map == null) {
                map = DefaultAsyncContextProvider.newContextMap();
                contextMapHolder.context(map);
            }
            return map;
        }
        return CONTEXT_THREAD_LOCAL.get();
    }

    @Override
    public final void setContextMap(ContextMap contextMap) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            asyncContextMapHolder.context(contextMap);
        } else {
            CONTEXT_THREAD_LOCAL.set(contextMap);
        }
    }

    @Override
    public final Scope attachContextMap(ContextMap contextMap) {
        return DefaultAsyncContextProvider.doAttachContextMap(contextMap);
    }

    @Override
    public final CapturedContext captureContext() {
        return this.captureContext(this.context());
    }

    @Override
    public CapturedContext captureContext(ContextMap contextMap) {
        return this.convertToCapturedContext(contextMap);
    }

    @Override
    public CapturedContext captureContextCopy() {
        return this.convertToCapturedContext(this.context().copy());
    }

    private CapturedContext convertToCapturedContext(ContextMap contextMap) {
        return contextMap instanceof CapturedContext ? (CapturedContext)contextMap : new CapturedContextImpl(contextMap);
    }

    @Override
    public final CompletableSource.Subscriber wrapCancellable(CompletableSource.Subscriber subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingCompletableSubscriber) {
            ContextPreservingCompletableSubscriber s = (ContextPreservingCompletableSubscriber)subscriber;
            return s.cancellableCapturedContext == context ? subscriber : new ContextPreservingCompletableSubscriber(s.subscriber, context, s.subscriberCapturedContext);
        }
        return new ContextPreservingCompletableSubscriber(subscriber, context, null);
    }

    @Override
    public final CompletableSource.Subscriber wrapCompletableSubscriber(CompletableSource.Subscriber subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingCompletableSubscriber) {
            ContextPreservingCompletableSubscriber s = (ContextPreservingCompletableSubscriber)subscriber;
            return s.subscriberCapturedContext != null ? subscriber : new ContextPreservingCompletableSubscriber(s.subscriber, s.cancellableCapturedContext, context);
        }
        return new ContextPreservingCompletableSubscriber(subscriber, null, context);
    }

    @Override
    public final CompletableSource.Subscriber wrapCompletableSubscriberAndCancellable(CompletableSource.Subscriber subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingCompletableSubscriber) {
            ContextPreservingCompletableSubscriber s = (ContextPreservingCompletableSubscriber)subscriber;
            if (s.cancellableCapturedContext == context && s.subscriberCapturedContext != null) {
                return subscriber;
            }
            CapturedContext subscriberContext = s.subscriberCapturedContext == null ? context : s.subscriberCapturedContext;
            return new ContextPreservingCompletableSubscriber(s.subscriber, context, subscriberContext);
        }
        return new ContextPreservingCompletableSubscriber(subscriber, context, context);
    }

    @Override
    public final <T> SingleSource.Subscriber<T> wrapCancellable(SingleSource.Subscriber<T> subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingSingleSubscriber) {
            ContextPreservingSingleSubscriber s = subscriber;
            return s.cancellableCapturedContext == context ? subscriber : new ContextPreservingSingleSubscriber(s.subscriber, context, s.subscriberCapturedContext);
        }
        return new ContextPreservingSingleSubscriber<T>(subscriber, context, null);
    }

    @Override
    public final <T> SingleSource.Subscriber<T> wrapSingleSubscriber(SingleSource.Subscriber<T> subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingSingleSubscriber) {
            ContextPreservingSingleSubscriber s = subscriber;
            return s.subscriberCapturedContext != null ? subscriber : new ContextPreservingSingleSubscriber(s.subscriber, s.cancellableCapturedContext, context);
        }
        return new ContextPreservingSingleSubscriber<T>(subscriber, null, context);
    }

    @Override
    public final <T> SingleSource.Subscriber<T> wrapSingleSubscriberAndCancellable(SingleSource.Subscriber<T> subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingSingleSubscriber) {
            ContextPreservingSingleSubscriber s = (ContextPreservingSingleSubscriber)subscriber;
            if (s.cancellableCapturedContext == context && s.subscriberCapturedContext != null) {
                return subscriber;
            }
            CapturedContext subscriberContext = s.subscriberCapturedContext == null ? context : s.subscriberCapturedContext;
            return new ContextPreservingSingleSubscriber(s.subscriber, context, subscriberContext);
        }
        return new ContextPreservingSingleSubscriber<T>(subscriber, context, context);
    }

    @Override
    public final <T> PublisherSource.Subscriber<T> wrapSubscription(PublisherSource.Subscriber<T> subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingSubscriber) {
            ContextPreservingSubscriber s = subscriber;
            return s.subscriptionCapturedContext == context ? subscriber : new ContextPreservingSubscriber(s.subscriber, context, s.subscriberCapturedContext);
        }
        return new ContextPreservingSubscriber<T>(subscriber, context, null);
    }

    @Override
    public final <T> PublisherSource.Subscriber<T> wrapPublisherSubscriber(PublisherSource.Subscriber<T> subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingSubscriber) {
            ContextPreservingSubscriber s = subscriber;
            return s.subscriberCapturedContext != null ? subscriber : new ContextPreservingSubscriber(s.subscriber, s.subscriptionCapturedContext, context);
        }
        return new ContextPreservingSubscriber<T>(subscriber, null, context);
    }

    @Override
    public final <T> PublisherSource.Subscriber<T> wrapPublisherSubscriberAndSubscription(PublisherSource.Subscriber<T> subscriber, CapturedContext context) {
        if (subscriber instanceof ContextPreservingSubscriber) {
            ContextPreservingSubscriber s = (ContextPreservingSubscriber)subscriber;
            if (s.subscriptionCapturedContext == context && s.subscriberCapturedContext != null) {
                return subscriber;
            }
            CapturedContext subscriberContext = s.subscriberCapturedContext == null ? context : s.subscriberCapturedContext;
            return new ContextPreservingSubscriber(s.subscriber, context, subscriberContext);
        }
        return new ContextPreservingSubscriber<T>(subscriber, context, context);
    }

    @Override
    public final java.util.concurrent.Executor wrapJdkExecutor(java.util.concurrent.Executor executor) {
        return ContextPreservingExecutor.of(executor);
    }

    @Override
    public final ExecutorService wrapJdkExecutorService(ExecutorService executor) {
        return ContextPreservingExecutorService.of(executor);
    }

    @Override
    public final Executor wrapExecutor(Executor executor) {
        return ContextPreservingStExecutor.of(executor);
    }

    @Override
    public final ScheduledExecutorService wrapJdkScheduledExecutorService(ScheduledExecutorService executor) {
        return ContextPreservingScheduledExecutorService.of(executor);
    }

    @Override
    public final <T> CompletableFuture<T> wrapCompletableFuture(CompletableFuture<T> future, CapturedContext context) {
        return ContextPreservingCompletableFuture.newContextPreservingFuture(future, context);
    }

    @Override
    public final Runnable wrapRunnable(Runnable runnable, CapturedContext context) {
        return new ContextPreservingRunnable(runnable, context);
    }

    @Override
    public final <V> Callable<V> wrapCallable(Callable<V> callable, CapturedContext context) {
        return new ContextPreservingCallable<V>(callable, context);
    }

    @Override
    public final <T> Consumer<T> wrapConsumer(Consumer<T> consumer, CapturedContext context) {
        return new ContextPreservingConsumer<T>(consumer, context);
    }

    @Override
    public final <T, U> Function<T, U> wrapFunction(Function<T, U> func, CapturedContext context) {
        return new ContextPreservingFunction<T, U>(func, context);
    }

    @Override
    public final <T, U> BiConsumer<T, U> wrapBiConsumer(BiConsumer<T, U> consumer, CapturedContext context) {
        return new ContextPreservingBiConsumer<T, U>(consumer, context);
    }

    @Override
    public final <T, U, V> BiFunction<T, U, V> wrapBiFunction(BiFunction<T, U, V> func, CapturedContext context) {
        return new ContextPreservingBiFunction<T, U, V>(func, context);
    }

    private static Scope doAttachContextMap(ContextMap contextMap) {
        ContextMap prev = DefaultAsyncContextProvider.exchangeContext(contextMap);
        return NO_DEBUG_LOGGING && prev instanceof Scope ? (Scope)prev : new DetachScope(contextMap, prev);
    }

    private static ContextMap exchangeContext(ContextMap contextMap) {
        ContextMap result;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            result = asyncContextMapHolder.context();
            if (result == null) {
                result = DefaultAsyncContextProvider.newContextMap();
            }
            asyncContextMapHolder.context(contextMap);
        } else {
            result = CONTEXT_THREAD_LOCAL.get();
            CONTEXT_THREAD_LOCAL.set(contextMap);
        }
        return result;
    }

    private static ContextMap newContextMap() {
        return new CopyOnWriteContextMap();
    }

    private static boolean isNoDebugLogging() {
        try {
            return !LOGGER.isDebugEnabled();
        }
        catch (Exception ex) {
            System.err.println("Could not evaluate logging level, considering debug level is disabled by default. Cause:" + System.lineSeparator() + ex);
            ex.printStackTrace(System.err);
            return true;
        }
    }

    private static final class CapturedContextImpl
    implements CapturedContext {
        private final ContextMap contextMap;

        CapturedContextImpl(ContextMap contextMap) {
            this.contextMap = contextMap;
        }

        @Override
        public ContextMap captured() {
            return this.contextMap;
        }

        @Override
        public Scope attachContext() {
            return DefaultAsyncContextProvider.doAttachContextMap(this.contextMap);
        }
    }

    private static final class DetachScope
    implements Scope {
        private final ContextMap expectedContext;
        private final ContextMap toRestore;

        DetachScope(ContextMap expectedContext, ContextMap toRestore) {
            this.expectedContext = expectedContext;
            this.toRestore = toRestore;
        }

        @Override
        public void close() {
            ContextMap current = DefaultAsyncContextProvider.exchangeContext(this.toRestore);
            if (current != this.expectedContext && !NO_DEBUG_LOGGING) {
                LOGGER.debug("Current context didn't match the expected context. current: {}, expected: {}", new Object[]{current, this.expectedContext, new Throwable("stack trace")});
            }
        }
    }
}

