/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ExecutorPlugin;
import io.servicetalk.concurrent.internal.ArrayUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class CopyOnWriteExecutorPluginSet
implements ExecutorPlugin {
    private final AtomicReference<CopyOnWriteSet> setRef = new AtomicReference<CopyOnWriteSet>(EmptyExecutorPluginSet.INSTANCE);

    CopyOnWriteExecutorPluginSet() {
    }

    boolean add(ExecutorPlugin plugin) {
        CopyOnWriteSet afterAddSet;
        CopyOnWriteSet set;
        Objects.requireNonNull(plugin);
        do {
            if ((set = this.setRef.get()) != (afterAddSet = set.add(plugin))) continue;
            return false;
        } while (!this.setRef.compareAndSet(set, afterAddSet));
        return true;
    }

    boolean remove(ExecutorPlugin plugin) {
        CopyOnWriteSet afterRemoveSet;
        CopyOnWriteSet set;
        do {
            if ((set = this.setRef.get()) != (afterRemoveSet = set.remove(plugin))) continue;
            return false;
        } while (!this.setRef.compareAndSet(set, afterRemoveSet));
        return true;
    }

    void clear() {
        this.setRef.set(EmptyExecutorPluginSet.INSTANCE);
    }

    @Override
    public Executor wrapExecutor(Executor result) {
        return this.setRef.get().wrapExecutor(result);
    }

    private static final class EmptyExecutorPluginSet
    implements CopyOnWriteSet {
        static final CopyOnWriteSet INSTANCE = new EmptyExecutorPluginSet();

        private EmptyExecutorPluginSet() {
        }

        @Override
        public CopyOnWriteSet add(ExecutorPlugin plugin) {
            return new OneExecutorPluginSet(plugin);
        }

        @Override
        public CopyOnWriteSet remove(ExecutorPlugin plugin) {
            return this;
        }

        @Override
        public Executor wrapExecutor(Executor result) {
            return result;
        }
    }

    private static interface CopyOnWriteSet
    extends ExecutorPlugin {
        public CopyOnWriteSet add(ExecutorPlugin var1);

        public CopyOnWriteSet remove(ExecutorPlugin var1);
    }

    private static final class ThreeOrMoreExecutorPluginSet
    implements CopyOnWriteSet {
        private final ExecutorPlugin[] plugins;

        ThreeOrMoreExecutorPluginSet(ExecutorPlugin ... plugins) {
            this.plugins = plugins;
        }

        @Override
        public CopyOnWriteSet add(ExecutorPlugin plugin) {
            int i = ArrayUtils.indexOf((Object)plugin, (Object[])this.plugins);
            if (i >= 0) {
                return this;
            }
            ExecutorPlugin[] newArray = Arrays.copyOf(this.plugins, this.plugins.length + 1);
            newArray[this.plugins.length] = plugin;
            return new ThreeOrMoreExecutorPluginSet(newArray);
        }

        @Override
        public CopyOnWriteSet remove(ExecutorPlugin plugin) {
            int i = ArrayUtils.indexOf((Object)plugin, (Object[])this.plugins);
            if (i < 0) {
                return this;
            }
            if (this.plugins.length == 3) {
                switch (i) {
                    case 0: {
                        return new TwoExecutorPluginSet(this.plugins[1], this.plugins[2]);
                    }
                    case 1: {
                        return new TwoExecutorPluginSet(this.plugins[0], this.plugins[2]);
                    }
                    case 2: {
                        return new TwoExecutorPluginSet(this.plugins[0], this.plugins[1]);
                    }
                }
                throw new IllegalStateException("programming error. i: " + i);
            }
            ExecutorPlugin[] newArray = new ExecutorPlugin[this.plugins.length - 1];
            System.arraycopy(this.plugins, 0, newArray, 0, i);
            System.arraycopy(this.plugins, i + 1, newArray, i, this.plugins.length - i - 1);
            return new ThreeOrMoreExecutorPluginSet(newArray);
        }

        @Override
        public Executor wrapExecutor(Executor result) {
            Executor executor = this.plugins[2].wrapExecutor(this.plugins[1].wrapExecutor(this.plugins[0].wrapExecutor(result)));
            for (int i = 3; i < this.plugins.length; ++i) {
                executor = this.plugins[i].wrapExecutor(executor);
            }
            return executor;
        }
    }

    private static final class TwoExecutorPluginSet
    implements CopyOnWriteSet {
        private final ExecutorPlugin first;
        private final ExecutorPlugin second;

        TwoExecutorPluginSet(ExecutorPlugin first, ExecutorPlugin second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public CopyOnWriteSet add(ExecutorPlugin plugin) {
            return this.first.equals(plugin) || this.second.equals(plugin) ? this : new ThreeOrMoreExecutorPluginSet(this.first, this.second, plugin);
        }

        @Override
        public CopyOnWriteSet remove(ExecutorPlugin plugin) {
            if (this.first.equals(plugin)) {
                return new OneExecutorPluginSet(this.second);
            }
            if (this.second.equals(plugin)) {
                return new OneExecutorPluginSet(this.first);
            }
            return this;
        }

        @Override
        public Executor wrapExecutor(Executor result) {
            return this.second.wrapExecutor(this.first.wrapExecutor(result));
        }
    }

    private static final class OneExecutorPluginSet
    implements CopyOnWriteSet {
        private final ExecutorPlugin plugin;

        OneExecutorPluginSet(ExecutorPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public CopyOnWriteSet add(ExecutorPlugin plugin) {
            return this.plugin.equals(plugin) ? this : new TwoExecutorPluginSet(this.plugin, plugin);
        }

        @Override
        public CopyOnWriteSet remove(ExecutorPlugin plugin) {
            return this.plugin.equals(plugin) ? EmptyExecutorPluginSet.INSTANCE : this;
        }

        @Override
        public Executor wrapExecutor(Executor result) {
            return this.plugin.wrapExecutor(result);
        }
    }
}

