/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.ContextPreservingCallable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;

final class ContextAwareExecutorUtils {
    private ContextAwareExecutorUtils() {
    }

    static <X> Collection<? extends Callable<X>> wrap(Collection<? extends Callable<X>> tasks) {
        ArrayList<ContextPreservingCallable<X>> wrappedTasks = new ArrayList<ContextPreservingCallable<X>>(tasks.size());
        CapturedContext capturedContext = AsyncContext.provider().captureContext();
        for (Callable<X> task : tasks) {
            wrappedTasks.add(new ContextPreservingCallable<X>(task, capturedContext));
        }
        return wrappedTasks;
    }
}

