/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleSingleSubscriber<T>
extends SequentialCancellable
implements SingleSource.Subscriber<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSingleSubscriber.class);
    private final Consumer<? super T> resultConsumer;
    @Nullable
    private final Consumer<? super Throwable> errorConsumer;

    SimpleSingleSubscriber(Consumer<? super T> resultConsumer) {
        this.resultConsumer = Objects.requireNonNull(resultConsumer);
        this.errorConsumer = null;
    }

    SimpleSingleSubscriber(Consumer<? super T> resultConsumer, Consumer<? super Throwable> errorConsumer) {
        this.resultConsumer = Objects.requireNonNull(resultConsumer);
        this.errorConsumer = Objects.requireNonNull(errorConsumer);
    }

    public void onSubscribe(Cancellable cancellable) {
        this.nextCancellable(cancellable);
    }

    public void onSuccess(@Nullable T result) {
        try {
            this.resultConsumer.accept(result);
        }
        catch (Throwable t) {
            LOGGER.debug("Received exception from the result consumer {}.", this.resultConsumer, (Object)t);
        }
    }

    public void onError(Throwable t) {
        if (this.errorConsumer != null) {
            this.errorConsumer.accept(t);
        } else {
            LOGGER.debug("Received exception from the source.", t);
        }
    }
}

