/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.ScanLifetimeMapper;
import io.servicetalk.concurrent.api.ScanMapper;
import io.servicetalk.concurrent.api.ScanWithLifetimeMapper;
import io.servicetalk.concurrent.api.ScanWithPublisher;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ScanWithLifetimePublisher<T, R>
extends AbstractNoHandleSubscribePublisher<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanWithLifetimePublisher.class);
    private final Publisher<T> original;
    private final Supplier<? extends ScanLifetimeMapper<? super T, ? extends R>> mapperSupplier;

    ScanWithLifetimePublisher(Publisher<T> original, Supplier<? extends ScanWithLifetimeMapper<? super T, ? extends R>> mapperSupplier) {
        this(new SupplierScanMapperLifetime(mapperSupplier), original);
    }

    ScanWithLifetimePublisher(Supplier<? extends ScanLifetimeMapper<? super T, ? extends R>> mapperSupplier, Publisher<T> original) {
        this.mapperSupplier = Objects.requireNonNull(mapperSupplier);
        this.original = original;
    }

    @Override
    CapturedContext contextForSubscribe(AsyncContextProvider provider) {
        return provider.captureContext();
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super R> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ScanWithLifetimeSubscriber<T, R>(subscriber, this.mapperSupplier.get(), capturedContext, contextProvider), capturedContext, contextProvider);
    }

    private static final class SupplierScanMapperLifetime<T, R>
    implements Supplier<ScanLifetimeMapper<T, R>> {
        private final Supplier<? extends ScanWithLifetimeMapper<? super T, ? extends R>> mapperSupplier;

        private SupplierScanMapperLifetime(Supplier<? extends ScanWithLifetimeMapper<? super T, ? extends R>> mapperSupplier) {
            this.mapperSupplier = Objects.requireNonNull(mapperSupplier);
        }

        @Override
        public ScanLifetimeMapper<T, R> get() {
            return new ScanMapperLifetimeAdapter<T, R>(this.mapperSupplier.get());
        }
    }

    private static final class ScanWithLifetimeSubscriber<T, R>
    extends ScanWithPublisher.ScanWithSubscriber<T, R> {
        private static final int STATE_UNLOCKED = 0;
        private static final int STATE_BUSY = 1;
        private static final int STATE_FINALIZED = 2;
        private static final int STATE_FINALIZE_PENDING_FOR_SUBSCRIBER = 3;
        private static final AtomicIntegerFieldUpdater<ScanWithLifetimeSubscriber> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ScanWithLifetimeSubscriber.class, "state");
        private volatile int state = 0;
        private final ScanLifetimeMapper<? super T, ? extends R> mapper;

        ScanWithLifetimeSubscriber(PublisherSource.Subscriber<? super R> subscriber, ScanLifetimeMapper<? super T, ? extends R> mapper, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            super(subscriber, mapper, contextProvider, capturedContext);
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        protected void onCancel() {
            block3: {
                int prevState;
                block4: {
                    while (true) {
                        if ((prevState = this.state) == 1) {
                            if (!stateUpdater.compareAndSet(this, 1, 3)) continue;
                            break block3;
                        }
                        if (prevState != 0) break block4;
                        if (stateUpdater.compareAndSet(this, 0, 2)) break;
                    }
                    this.finalize0();
                    break block3;
                }
                assert (prevState == 2 || prevState == 3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(@Nullable T t) {
            int prevState;
            boolean reentry = false;
            do {
                if ((prevState = this.state) == 1 || prevState == 3) {
                    reentry = true;
                    break;
                }
                if (prevState != 2) continue;
                return;
            } while (!stateUpdater.compareAndSet(this, 0, 1));
            try {
                super.onNext(t);
            }
            finally {
                block10: {
                    if (!reentry) {
                        while (true) {
                            prevState = this.state;
                            assert (prevState != 0 && prevState != 2);
                            if (prevState == 1) {
                                if (!stateUpdater.compareAndSet(this, 1, 0)) continue;
                                break block10;
                            }
                            if (stateUpdater.compareAndSet(this, 3, 2)) break;
                        }
                        this.finalize0();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            boolean reentry = false;
            do {
                int prevState;
                if ((prevState = this.state) == 1 || prevState == 3) {
                    reentry = true;
                    break;
                }
                if (prevState != 2) continue;
                return;
            } while (!stateUpdater.compareAndSet(this, 0, 1));
            boolean completed = true;
            try {
                completed = super.onError0(t);
            }
            finally {
                this.releaseFromTerminal(reentry, completed);
            }
        }

        @Override
        public void onComplete() {
            boolean reentry = false;
            do {
                int prevState;
                if ((prevState = this.state) == 1 || prevState == 3) {
                    reentry = true;
                    break;
                }
                if (prevState != 2) continue;
                return;
            } while (!stateUpdater.compareAndSet(this, 0, 1));
            boolean completed = true;
            try {
                completed = super.onComplete0();
            }
            finally {
                this.releaseFromTerminal(reentry, completed);
            }
        }

        @Override
        protected void deliverAllTerminalFromSubscription(ScanMapper.MappedTerminal<? extends R> mappedTerminal, PublisherSource.Subscriber<? super R> subscriber) {
            if (this.shouldDeliverFromSubscription()) {
                try {
                    super.deliverAllTerminalFromSubscription(mappedTerminal, subscriber);
                }
                finally {
                    this.state = 2;
                    this.finalize0();
                }
            }
        }

        private boolean shouldDeliverFromSubscription() {
            return this.state != 2;
        }

        private void releaseFromTerminal(boolean reentry, boolean completed) {
            block8: {
                if (!completed) {
                    if (!reentry) {
                        while (true) {
                            int prevState = this.state;
                            assert (prevState != 0 && prevState != 2);
                            if (prevState == 1) {
                                if (!stateUpdater.compareAndSet(this, 1, 0)) continue;
                                break block8;
                            }
                            if (stateUpdater.compareAndSet(this, 3, 2)) break;
                        }
                        this.finalize0();
                    }
                } else if (reentry) {
                    this.state = 3;
                } else {
                    this.state = 2;
                    this.finalize0();
                }
            }
        }

        private void finalize0() {
            try {
                this.mapper.afterFinally();
            }
            catch (Throwable cause) {
                LOGGER.error("Unexpected error occurred during finalization.", cause);
            }
        }
    }

    private static final class ScanMapperLifetimeAdapter<T, R>
    extends ScanWithPublisher.ScanMapperAdapter<T, R, ScanWithLifetimeMapper<? super T, ? extends R>>
    implements ScanLifetimeMapper<T, R> {
        ScanMapperLifetimeAdapter(ScanWithLifetimeMapper<? super T, ? extends R> mapper) {
            super(mapper);
        }

        @Override
        public void afterFinally() {
            ((ScanWithLifetimeMapper)this.mapper).afterFinally();
        }
    }
}

