/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.function.BiPredicate;

final class RedoPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final boolean terminateOnNextException;
    private final Publisher<T> original;
    private final BiPredicate<Integer, TerminalNotification> shouldRedo;

    RedoPublisher(Publisher<T> original, boolean terminateOnNextException, BiPredicate<Integer, TerminalNotification> shouldRedo) {
        this.original = original;
        this.terminateOnNextException = terminateOnNextException;
        this.shouldRedo = shouldRedo;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new RedoSubscriber<T>(this.terminateOnNextException, new SequentialSubscription(), 0, subscriber, capturedContext, contextProvider, this), capturedContext, contextProvider);
    }

    private static final class RedoSubscriber<T>
    extends AbstractRedoSubscriber<T> {
        private final RedoPublisher<T> redoPublisher;
        private final CapturedContext capturedContext;
        private final AsyncContextProvider contextProvider;

        RedoSubscriber(boolean terminateOnNextException, SequentialSubscription subscription, int redoCount, PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider, RedoPublisher<T> redoPublisher) {
            super(terminateOnNextException, subscription, redoCount, subscriber);
            this.redoPublisher = redoPublisher;
            this.capturedContext = capturedContext;
            this.contextProvider = contextProvider;
        }

        @Override
        void onError0(Throwable t) {
            this.tryRedo(TerminalNotification.error((Throwable)t));
        }

        @Override
        void onComplete0() {
            this.tryRedo(TerminalNotification.complete());
        }

        private void tryRedo(TerminalNotification notification) {
            boolean shouldRedo;
            try {
                shouldRedo = ((RedoPublisher)this.redoPublisher).shouldRedo.test(++this.redoCount, notification);
            }
            catch (Throwable cause) {
                Throwable originalCause = notification.cause();
                if (originalCause != null) {
                    ThrowableUtils.addSuppressed((Throwable)cause, (Throwable)originalCause);
                }
                this.subscriber.onError(cause);
                return;
            }
            if (shouldRedo) {
                ((RedoPublisher)this.redoPublisher).original.delegateSubscribeWithContext(this, this.capturedContext, this.contextProvider);
            } else {
                notification.terminate(this.subscriber);
            }
        }
    }

    static abstract class AbstractRedoSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final boolean terminateOnNextException;
        private final SequentialSubscription subscription;
        private boolean terminated;
        final PublisherSource.Subscriber<? super T> subscriber;
        int redoCount;

        AbstractRedoSubscriber(boolean terminateOnNextException, SequentialSubscription subscription, int redoCount, PublisherSource.Subscriber<? super T> subscriber) {
            this.terminateOnNextException = terminateOnNextException;
            this.subscription = subscription;
            this.redoCount = redoCount;
            this.subscriber = subscriber;
        }

        public final void onSubscribe(PublisherSource.Subscription s) {
            s = this.decorate(s);
            if (this.terminateOnNextException) {
                s = ConcurrentSubscription.wrap((PublisherSource.Subscription)s);
            }
            this.subscription.switchTo(s);
            if (this.redoCount == 0) {
                this.subscriber.onSubscribe((PublisherSource.Subscription)this.subscription);
            }
        }

        public final void onNext(T t) {
            if (this.terminated) {
                return;
            }
            this.subscription.itemReceived();
            try {
                this.subscriber.onNext(t);
            }
            catch (Throwable cause) {
                this.handleOnNextException(cause);
            }
        }

        public final void onError(Throwable cause) {
            if (this.terminated) {
                return;
            }
            this.onError0(cause);
        }

        public final void onComplete() {
            if (this.terminated) {
                return;
            }
            this.onComplete0();
        }

        abstract void onComplete0();

        abstract void onError0(Throwable var1);

        PublisherSource.Subscription decorate(PublisherSource.Subscription s) {
            return s;
        }

        private void handleOnNextException(Throwable cause) {
            cause = SubscriberUtils.newExceptionNormalReturn((Throwable)cause);
            if (!this.terminateOnNextException) {
                ThrowableUtils.throwException((Throwable)cause);
            } else if (this.terminated) {
                return;
            }
            this.terminated = true;
            try {
                this.subscription.cancel();
            }
            finally {
                this.subscriber.onError(cause);
            }
        }
    }
}

