/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractPubToCompletable;
import io.servicetalk.concurrent.api.Publisher;
import javax.annotation.Nullable;

final class PubCompletableOrError<T>
extends AbstractPubToCompletable<T> {
    PubCompletableOrError(Publisher<T> source) {
        super(source);
    }

    @Override
    PublisherSource.Subscriber<T> newSubscriber(CompletableSource.Subscriber original) {
        return new PubToCompletableOrErrorSubscriber(original);
    }

    private static final class PubToCompletableOrErrorSubscriber<T>
    extends AbstractPubToCompletable.AbstractPubToCompletableSubscriber<T> {
        private boolean terminated;

        PubToCompletableOrErrorSubscriber(CompletableSource.Subscriber subscriber) {
            super(subscriber);
        }

        public void onNext(@Nullable T t) {
            if (!this.terminated) {
                this.terminated = true;
                try {
                    super.onError(new IllegalArgumentException("No onNext signals expected, but got: " + t));
                }
                finally {
                    this.cancel();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (!this.terminated) {
                this.terminated = true;
                super.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminated) {
                this.terminated = true;
                super.onComplete();
            }
        }
    }
}

