/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.SequentialSubscription;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class OnErrorResumePublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Publisher<T> original;
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory;

    OnErrorResumePublisher(Publisher<T> original, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Publisher<? extends T>> nextFactory) {
        this.original = original;
        this.predicate = Objects.requireNonNull(predicate);
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ResumeSubscriber(subscriber, capturedContext, contextProvider), capturedContext, contextProvider);
    }

    private final class ResumeSubscriber
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final CapturedContext capturedContext;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialSubscription sequentialSubscription;
        private boolean resubscribed;

        ResumeSubscriber(PublisherSource.Subscriber<? super T> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.capturedContext = capturedContext;
            this.contextProvider = contextProvider;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            if (this.sequentialSubscription == null) {
                this.sequentialSubscription = new SequentialSubscription(s);
                this.subscriber.onSubscribe((PublisherSource.Subscription)this.sequentialSubscription);
            } else {
                this.resubscribed = true;
                this.sequentialSubscription.switchTo(s);
            }
        }

        public void onNext(T t) {
            assert (this.sequentialSubscription != null);
            this.sequentialSubscription.itemReceived();
            this.subscriber.onNext(t);
        }

        public void onError(Throwable throwable) {
            Publisher next;
            try {
                next = !this.resubscribed && OnErrorResumePublisher.this.predicate.test(throwable) ? Objects.requireNonNull((Publisher)OnErrorResumePublisher.this.nextFactory.apply(throwable)) : null;
            }
            catch (Throwable t) {
                this.subscriber.onError(ThrowableUtils.addSuppressed((Throwable)t, (Throwable)throwable));
                return;
            }
            if (next == null) {
                this.subscriber.onError(throwable);
            } else {
                PublisherSource.Subscriber offloadedSubscriber = this.contextProvider.wrapPublisherSubscriber(this, this.capturedContext);
                next.subscribeInternal(offloadedSubscriber);
            }
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

