/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.CopyOnWriteExecutorPluginSet;
import io.servicetalk.concurrent.api.DefaultExecutor;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.GlobalExecutor;
import io.servicetalk.concurrent.api.ImmediateExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;

public final class Executors {
    static final CopyOnWriteExecutorPluginSet EXECUTOR_PLUGINS = new CopyOnWriteExecutorPluginSet();

    private Executors() {
    }

    public static Executor immediate() {
        return ImmediateExecutor.IMMEDIATE_EXECUTOR;
    }

    public static Executor global() {
        return GlobalExecutor.GLOBAL_EXECUTOR;
    }

    public static Executor newFixedSizeExecutor(int size) {
        return Executors.newFixedSizeExecutor(size, new DefaultThreadFactory());
    }

    public static Executor newFixedSizeExecutor(int size, ThreadFactory threadFactory) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor(size, size, new LinkedBlockingQueue<Runnable>(), threadFactory));
    }

    public static Executor newCachedThreadExecutor() {
        return Executors.newCachedThreadExecutor(new DefaultThreadFactory());
    }

    public static Executor newCachedThreadExecutor(ThreadFactory threadFactory) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor(1, Integer.MAX_VALUE, new SynchronousQueue<Runnable>(), threadFactory));
    }

    public static Executor from(java.util.concurrent.Executor jdkExecutor) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor(jdkExecutor));
    }

    public static Executor from(ExecutorService executorService) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor(executorService));
    }

    public static Executor from(ExecutorService executorService, boolean mayInterruptOnCancel) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor((java.util.concurrent.Executor)executorService, mayInterruptOnCancel));
    }

    public static Executor from(ScheduledExecutorService scheduledExecutorService) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor((java.util.concurrent.Executor)scheduledExecutorService, scheduledExecutorService));
    }

    public static Executor from(ScheduledExecutorService scheduledExecutorService, boolean mayInterruptOnCancel) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor((java.util.concurrent.Executor)scheduledExecutorService, scheduledExecutorService, mayInterruptOnCancel));
    }

    public static Executor from(java.util.concurrent.Executor jdkExecutor, ScheduledExecutorService scheduledExecutorService) {
        return Executors.from(jdkExecutor, scheduledExecutorService, true);
    }

    public static Executor from(java.util.concurrent.Executor jdkExecutor, ScheduledExecutorService scheduledExecutorService, boolean mayInterruptOnCancel) {
        return EXECUTOR_PLUGINS.wrapExecutor(new DefaultExecutor(jdkExecutor, scheduledExecutorService, mayInterruptOnCancel));
    }

    static {
        AsyncContext.autoEnable();
    }
}

