/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.ContextPreservingSubscription;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;
import javax.annotation.Nullable;

final class ContextPreservingSubscriber<T>
implements PublisherSource.Subscriber<T> {
    @Nullable
    final CapturedContext subscriptionCapturedContext;
    @Nullable
    final CapturedContext subscriberCapturedContext;
    final PublisherSource.Subscriber<T> subscriber;

    ContextPreservingSubscriber(PublisherSource.Subscriber<T> subscriber, @Nullable CapturedContext subscriptionCapturedContext, @Nullable CapturedContext subscriberCapturedContext) {
        assert (subscriptionCapturedContext != null || subscriberCapturedContext != null);
        this.subscriber = Objects.requireNonNull(subscriber);
        this.subscriptionCapturedContext = subscriptionCapturedContext;
        this.subscriberCapturedContext = subscriberCapturedContext;
    }

    public void onSubscribe(PublisherSource.Subscription s) {
        if (this.subscriptionCapturedContext != null) {
            s = ContextPreservingSubscription.wrap(s, this.subscriptionCapturedContext);
        }
        if (this.subscriberCapturedContext == null) {
            this.subscriber.onSubscribe(s);
        } else {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onSubscribe(s);
            }
        }
    }

    public void onNext(@Nullable T t) {
        if (this.subscriberCapturedContext == null) {
            this.subscriber.onNext(t);
        } else {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onNext(t);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.subscriberCapturedContext == null) {
            this.subscriber.onError(t);
        } else {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onError(t);
            }
        }
    }

    public void onComplete() {
        if (this.subscriberCapturedContext == null) {
            this.subscriber.onComplete();
        } else {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onComplete();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

