/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.ContextPreservingCancellable;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;
import javax.annotation.Nullable;

final class ContextPreservingSingleSubscriber<T>
implements SingleSource.Subscriber<T> {
    @Nullable
    final CapturedContext subscriberCapturedContext;
    @Nullable
    final CapturedContext cancellableCapturedContext;
    final SingleSource.Subscriber<T> subscriber;

    ContextPreservingSingleSubscriber(SingleSource.Subscriber<T> subscriber, @Nullable CapturedContext cancellableCapturedContext, @Nullable CapturedContext subscriberCapturedContext) {
        assert (subscriberCapturedContext != null || cancellableCapturedContext != null);
        this.subscriber = Objects.requireNonNull(subscriber);
        this.subscriberCapturedContext = subscriberCapturedContext;
        this.cancellableCapturedContext = cancellableCapturedContext;
    }

    public void onSubscribe(Cancellable cancellable) {
        if (this.cancellableCapturedContext != null) {
            cancellable = ContextPreservingCancellable.wrap(cancellable, this.cancellableCapturedContext);
        }
        if (this.subscriberCapturedContext == null) {
            this.subscriber.onSubscribe(cancellable);
        } else {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onSubscribe(cancellable);
            }
        }
    }

    public void onSuccess(@Nullable T result) {
        if (this.subscriberCapturedContext == null) {
            this.subscriber.onSuccess(result);
        } else {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onSuccess(result);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.subscriberCapturedContext == null) {
            this.subscriber.onError(t);
        } else {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onError(t);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

