/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;

final class ContextPreservingRunnable
implements Runnable {
    private final CapturedContext capturedContext;
    private final Runnable delegate;

    ContextPreservingRunnable(Runnable delegate) {
        this(delegate, AsyncContext.provider().captureContext());
    }

    ContextPreservingRunnable(Runnable delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void run() {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.delegate.run();
        }
    }
}

