/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;
import java.util.function.Consumer;

final class ContextPreservingConsumer<T>
implements Consumer<T> {
    private final CapturedContext capturedContext;
    private final Consumer<T> delegate;

    ContextPreservingConsumer(Consumer<T> delegate, CapturedContext capturedContext) {
        this.capturedContext = Objects.requireNonNull(capturedContext);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void accept(T t) {
        try (Scope ignored = this.capturedContext.attachContext();){
            this.delegate.accept(t);
        }
    }
}

