/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.ContextPreservingCancellable;
import io.servicetalk.concurrent.api.Scope;
import java.util.Objects;
import javax.annotation.Nullable;

final class ContextPreservingCompletableSubscriber
implements CompletableSource.Subscriber {
    final CompletableSource.Subscriber subscriber;
    @Nullable
    final CapturedContext cancellableCapturedContext;
    @Nullable
    final CapturedContext subscriberCapturedContext;

    ContextPreservingCompletableSubscriber(CompletableSource.Subscriber subscriber, @Nullable CapturedContext cancellableCapturedContext, @Nullable CapturedContext subscriberCapturedContext) {
        assert (cancellableCapturedContext != null || subscriberCapturedContext != null);
        this.subscriber = Objects.requireNonNull(subscriber);
        this.cancellableCapturedContext = cancellableCapturedContext;
        this.subscriberCapturedContext = subscriberCapturedContext;
    }

    public void onSubscribe(Cancellable cancellable) {
        if (this.cancellableCapturedContext != null) {
            cancellable = ContextPreservingCancellable.wrap(cancellable, this.cancellableCapturedContext);
        }
        if (this.subscriberCapturedContext != null) {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onSubscribe(cancellable);
            }
        } else {
            this.subscriber.onSubscribe(cancellable);
        }
    }

    public void onComplete() {
        if (this.subscriberCapturedContext != null) {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onComplete();
            }
        } else {
            this.subscriber.onComplete();
        }
    }

    public void onError(Throwable t) {
        if (this.subscriberCapturedContext != null) {
            try (Scope ignored = this.subscriberCapturedContext.attachContext();){
                this.subscriber.onError(t);
            }
        } else {
            this.subscriber.onError(t);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.subscriber + ')';
    }
}

