/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.CapturedContextProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CapturedContextProviders {
    private static final List<CapturedContextProvider> PROVIDERS;

    private CapturedContextProviders() {
    }

    static List<CapturedContextProvider> providers() {
        return PROVIDERS;
    }

    private static <T> List<T> loadProviders(Class<T> clazz, ClassLoader classLoader) {
        ArrayList list = new ArrayList(0);
        for (T provider : ServiceLoader.load(clazz, classLoader)) {
            list.add(provider);
        }
        if (list.isEmpty()) {
            CapturedContextProviders.runLater(() -> CapturedContextProviders.getLogger().debug("ServiceLoader {}(s) registered: []", (Object)clazz.getSimpleName()));
            return Collections.emptyList();
        }
        CapturedContextProviders.runLater(() -> CapturedContextProviders.getLogger().info("ServiceLoader {}(s) registered: {}", (Object)clazz.getSimpleName(), (Object)list));
        return Collections.unmodifiableList(list);
    }

    static void runLater(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        t.setName(CapturedContextProviders.class.getSimpleName() + "-logging");
        t.start();
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(CapturedContextProviders.class);
    }

    static {
        ClassLoader classLoader = CapturedContextProviders.class.getClassLoader();
        List<Object> providers = Collections.emptyList();
        try {
            providers = CapturedContextProviders.loadProviders(CapturedContextProvider.class, classLoader);
        }
        catch (Throwable ex) {
            CapturedContextProviders.runLater(() -> CapturedContextProviders.getLogger().error("Failed to load {} instances", (Object)CapturedContextProvider.class.getName(), (Object)ex));
        }
        PROVIDERS = providers;
    }
}

