/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import java.util.Objects;

abstract class AbstractAsynchronousPublisherOperator<T, R>
extends AbstractNoHandleSubscribePublisher<R>
implements PublisherOperator<T, R> {
    final Publisher<T> original;

    AbstractAsynchronousPublisherOperator(Publisher<T> original) {
        this.original = Objects.requireNonNull(original);
    }

    @Override
    final void handleSubscribe(PublisherSource.Subscriber<? super R> subscriber, CapturedContext capturedContext, AsyncContextProvider contextProvider) {
        PublisherSource.Subscriber<? super R> operatorSubscriber = contextProvider.wrapPublisherSubscriberAndSubscription(subscriber, capturedContext);
        PublisherSource.Subscriber upstreamSubscriber = this.apply(operatorSubscriber);
        this.original.delegateSubscribe(upstreamSubscriber, capturedContext, contextProvider);
    }
}

