/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring;

import io.sentry.SentryOptions;
import io.sentry.protocol.User;
import io.sentry.spring.SentryUserProvider;
import io.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public final class SpringSecuritySentryUserProvider
implements SentryUserProvider {
    @NotNull
    private final SentryOptions options;

    public SpringSecuritySentryUserProvider(@NotNull SentryOptions options) {
        this.options = (SentryOptions)Objects.requireNonNull((Object)options, (String)"options is required");
    }

    @Override
    @Nullable
    public User provideUser() {
        SecurityContext context;
        if (this.options.isSendDefaultPii() && (context = SecurityContextHolder.getContext()) != null && context.getAuthentication() != null) {
            User user = new User();
            user.setUsername(context.getAuthentication().getName());
            return user;
        }
        return null;
    }
}

