/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.TracePropagationTargets;
import io.sentry.util.Objects;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class SentrySpanClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private final IHub hub;

    public SentrySpanClientHttpRequestInterceptor(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        ISpan span;
        Integer responseStatusCode = null;
        ClientHttpResponse response = null;
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            ClientHttpResponse clientHttpResponse = execution.execute(request, body);
            this.addBreadcrumb(request, body, responseStatusCode, response);
            return clientHttpResponse;
        }
        {
            BaggageHeader baggage;
            catch (Throwable throwable) {
                this.addBreadcrumb(request, body, responseStatusCode, response);
                throw throwable;
            }
            span = activeSpan.startChild("http.client");
            span.setDescription(request.getMethodValue() + " " + request.getURI());
            SentryTraceHeader sentryTraceHeader = span.toSentryTrace();
            if (TracePropagationTargets.contain((List)this.hub.getOptions().getTracePropagationTargets(), (URI)request.getURI())) {
                request.getHeaders().add(sentryTraceHeader.getName(), sentryTraceHeader.getValue());
                baggage = span.toBaggageHeader(request.getHeaders().get((Object)"baggage"));
                if (baggage != null) {
                    request.getHeaders().set(baggage.getName(), baggage.getValue());
                }
            }
            try {
                response = execution.execute(request, body);
                span.setStatus(SpanStatus.fromHttpStatusCode((int)response.getRawStatusCode()));
                responseStatusCode = response.getRawStatusCode();
                baggage = response;
                return baggage;
            }
            catch (Throwable e) {}
            {
                span.setThrowable(e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
                throw e;
            }
        }
        finally {
            span.finish();
        }
    }

    private void addBreadcrumb(@NotNull HttpRequest request, @NotNull byte[] body, @Nullable Integer responseStatusCode, @Nullable ClientHttpResponse response) {
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.getURI().toString(), (String)request.getMethodValue(), (Integer)responseStatusCode);
        breadcrumb.setData("request_body_size", (Object)body.length);
        Hint hint = new Hint();
        hint.set("springRequestInterceptor:request", (Object)request);
        hint.set("springRequestInterceptor:requestBody", (Object)body);
        if (response != null) {
            hint.set("springRequestInterceptor:response", (Object)response);
        }
        this.hub.addBreadcrumb(breadcrumb, hint);
    }
}

