/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.tracing;

import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class SentrySpanClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    @NotNull
    private final IHub hub;

    public SentrySpanClientHttpRequestInterceptor(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) throws IOException {
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null) {
            return execution.execute(request, body);
        }
        ISpan span = activeSpan.startChild("http.client");
        span.setDescription(request.getMethodValue() + " " + request.getURI());
        SentryTraceHeader sentryTraceHeader = span.toSentryTrace();
        request.getHeaders().add(sentryTraceHeader.getName(), sentryTraceHeader.getValue());
        try {
            ClientHttpResponse response = execution.execute(request, body);
            span.setStatus(SpanStatus.fromHttpStatusCode((int)response.getRawStatusCode()));
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (Exception e) {
            span.setThrowable((Throwable)e);
            span.setStatus(SpanStatus.INTERNAL_ERROR);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

