/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.webflux;

import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.spring.jakarta.webflux.ReactorUtils;
import io.sentry.spring.jakarta.webflux.TransactionNameProvider;
import io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

@Order(value=-2)
@ApiStatus.Experimental
public final class SentryWebExceptionHandler
implements WebExceptionHandler {
    public static final String MECHANISM_TYPE = "Spring6WebFluxExceptionResolver";
    @NotNull
    private final IHub hub;

    public SentryWebExceptionHandler(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    @NotNull
    public Mono<Void> handle(@NotNull ServerWebExchange serverWebExchange, @NotNull Throwable ex) {
        @Nullable IHub requestHub = (IHub)serverWebExchange.getAttributeOrDefault("sentry-hub", null);
        @NotNull IHub hubToUse = requestHub != null ? requestHub : this.hub;
        return ReactorUtils.withSentryHub(Mono.just((Object)ex).map(it -> {
            if (!(ex instanceof ResponseStatusException)) {
                Mechanism mechanism = new Mechanism();
                mechanism.setType(MECHANISM_TYPE);
                mechanism.setHandled(Boolean.valueOf(false));
                ExceptionMechanismException throwable = new ExceptionMechanismException(mechanism, ex, Thread.currentThread());
                SentryEvent event = new SentryEvent((Throwable)throwable);
                event.setLevel(SentryLevel.FATAL);
                event.setTransaction(TransactionNameProvider.provideTransactionName(serverWebExchange));
                Hint hint = new Hint();
                hint.set("webFluxExceptionHandler:request", (Object)serverWebExchange.getRequest());
                hint.set("webFluxExceptionHandler:response", (Object)serverWebExchange.getResponse());
                hint.set("webFluxExceptionHandler:exchange", (Object)serverWebExchange);
                this.hub.captureEvent(event, hint);
            }
            return it;
        }), hubToUse).flatMap(it -> Mono.error((Throwable)ex));
    }
}

