/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.tracing;

import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SpanStatus;
import io.sentry.spring.jakarta.tracing.SentrySpan;
import io.sentry.util.Objects;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class SentrySpanAdvice
implements MethodInterceptor {
    private static final String TRACE_ORIGIN = "auto.function.spring_jakarta.advice";
    @NotNull
    private final IHub hub;

    public SentrySpanAdvice(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        ISpan activeSpan = this.hub.getSpan();
        if (activeSpan == null || activeSpan.isNoOp()) {
            return invocation.proceed();
        }
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        Class<?> targetClass = invocation.getMethod().getDeclaringClass();
        SentrySpan sentrySpan = (SentrySpan)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentrySpan.class);
        if (sentrySpan == null) {
            sentrySpan = (SentrySpan)AnnotationUtils.findAnnotation(mostSpecificMethod.getDeclaringClass(), SentrySpan.class);
        }
        String operation = this.resolveSpanOperation(targetClass, mostSpecificMethod, sentrySpan);
        ISpan span = activeSpan.startChild(operation);
        span.getSpanContext().setOrigin(TRACE_ORIGIN);
        if (sentrySpan != null && !StringUtils.isEmpty((Object)sentrySpan.description())) {
            span.setDescription(sentrySpan.description());
        }
        try {
            Object result = invocation.proceed();
            span.setStatus(SpanStatus.OK);
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            span.setStatus(SpanStatus.INTERNAL_ERROR);
            span.setThrowable(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    private String resolveSpanOperation(Class<?> targetClass, Method method, @Nullable SentrySpan sentrySpan) {
        return sentrySpan == null || StringUtils.isEmpty((Object)sentrySpan.value()) ? targetClass.getSimpleName() + "." + method.getName() : sentrySpan.value();
    }
}

