/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.servlet;

import io.sentry.Breadcrumb;
import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ScopesAdapter;
import io.sentry.servlet.SentryRequestHttpServletRequestProcessor;
import io.sentry.util.LifecycleHelper;
import io.sentry.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;

public class SentryServletRequestListener
implements ServletRequestListener {
    public static final String SENTRY_SCOPE_LIFECYCLE_TOKEN_KEY = "sentry-scope-lifecycle";
    private final IScopes scopes;

    public SentryServletRequestListener(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
    }

    public SentryServletRequestListener() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public void requestDestroyed(@NotNull ServletRequestEvent servletRequestEvent) {
        ServletRequest servletRequest = servletRequestEvent.getServletRequest();
        LifecycleHelper.close((Object)servletRequest.getAttribute(SENTRY_SCOPE_LIFECYCLE_TOKEN_KEY));
    }

    public void requestInitialized(@NotNull ServletRequestEvent servletRequestEvent) {
        @NotNull ISentryLifecycleToken lifecycleToken = this.scopes.forkedScopes("SentryServletRequestListener").makeCurrent();
        ServletRequest servletRequest = servletRequestEvent.getServletRequest();
        servletRequest.setAttribute(SENTRY_SCOPE_LIFECYCLE_TOKEN_KEY, (Object)lifecycleToken);
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            Hint hint = new Hint();
            hint.set("servlet:request", (Object)httpRequest);
            this.scopes.addBreadcrumb(Breadcrumb.http((String)httpRequest.getRequestURI(), (String)httpRequest.getMethod()), hint);
            this.scopes.configureScope(scope -> scope.addEventProcessor((EventProcessor)new SentryRequestHttpServletRequestProcessor(httpRequest)));
        }
    }
}

