/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.okhttp;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HttpStatusCodeRange;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SpanStatus;
import io.sentry.okhttp.SentryOkHttpEvent;
import io.sentry.okhttp.SentryOkHttpEventListener;
import io.sentry.okhttp.SentryOkHttpUtils;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Platform;
import io.sentry.util.PropagationTargetsUtils;
import io.sentry.util.TracingUtils;
import io.sentry.util.UrlUtils;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001*B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bBE\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J,\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J1\u0010 \u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J'\u0010&\u001a\u00020\u0015*\u0004\u0018\u00010#2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00150(H\u0002\u00a2\u0006\u0002\u0010)R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/sentry/okhttp/SentryOkHttpInterceptor;", "Lokhttp3/Interceptor;", "()V", "hub", "Lio/sentry/IHub;", "(Lio/sentry/IHub;)V", "beforeSpan", "Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "(Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;)V", "captureFailedRequests", "", "failedRequestStatusCodes", "", "Lio/sentry/HttpStatusCodeRange;", "failedRequestTargets", "", "(Lio/sentry/IHub;Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;ZLjava/util/List;Ljava/util/List;)V", "containsStatusCode", "statusCode", "", "finishSpan", "", "span", "Lio/sentry/ISpan;", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "isFromEventListener", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "sendBreadcrumb", "code", "startTimestamp", "", "(Lokhttp3/Request;Ljava/lang/Integer;Lokhttp3/Response;J)V", "shouldCaptureClientError", "ifHasValidLength", "fn", "Lkotlin/Function1;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "BeforeSpanCallback", "sentry-okhttp"})
@SourceDebugExtension(value={"SMAP\nSentryOkHttpInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryOkHttpInterceptor.kt\nio/sentry/okhttp/SentryOkHttpInterceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1#2:239\n*E\n"})
public class SentryOkHttpInterceptor
implements Interceptor {
    @NotNull
    private final IHub hub;
    @Nullable
    private final BeforeSpanCallback beforeSpan;
    private final boolean captureFailedRequests;
    @NotNull
    private final List<HttpStatusCodeRange> failedRequestStatusCodes;
    @NotNull
    private final List<String> failedRequestTargets;

    public SentryOkHttpInterceptor(@NotNull IHub hub, @Nullable BeforeSpanCallback beforeSpan, boolean captureFailedRequests, @NotNull List<HttpStatusCodeRange> failedRequestStatusCodes, @NotNull List<String> failedRequestTargets) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter(failedRequestStatusCodes, (String)"failedRequestStatusCodes");
        Intrinsics.checkNotNullParameter(failedRequestTargets, (String)"failedRequestTargets");
        this.hub = hub;
        this.beforeSpan = beforeSpan;
        this.captureFailedRequests = captureFailedRequests;
        this.failedRequestStatusCodes = failedRequestStatusCodes;
        this.failedRequestTargets = failedRequestTargets;
        IntegrationUtils.addIntegrationToSdkVersion((String)"OkHttp");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-okhttp", "7.16.0");
    }

    public /* synthetic */ SentryOkHttpInterceptor(IHub iHub, BeforeSpanCallback beforeSpanCallback, boolean bl, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            beforeSpanCallback = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)new HttpStatusCodeRange(500, 599));
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.listOf((Object)".*");
        }
        this(iHub, beforeSpanCallback, bl, list, list2);
    }

    public SentryOkHttpInterceptor() {
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
        this((IHub)hubAdapter);
    }

    public SentryOkHttpInterceptor(@NotNull IHub hub) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, null, false, null, null, 28, null);
    }

    public SentryOkHttpInterceptor(@NotNull BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)beforeSpan, (String)"beforeSpan");
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
        this((IHub)hubAdapter, beforeSpan, false, null, null, 28, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.url().toString());
        Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(request.url.toString())");
        UrlUtils.UrlDetails urlDetails2 = urlDetails;
        String string = urlDetails2.getUrlOrFallback();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlDetails.urlOrFallback");
        String url = string;
        String method = request.method();
        ISpan span = null;
        SentryOkHttpEvent okHttpEvent = null;
        if (SentryOkHttpEventListener.Companion.getEventMap$sentry_okhttp().containsKey(chain.call())) {
            SentryOkHttpEvent sentryOkHttpEvent = okHttpEvent = SentryOkHttpEventListener.Companion.getEventMap$sentry_okhttp().get(chain.call());
            span = sentryOkHttpEvent != null ? sentryOkHttpEvent.getCallRootSpan$sentry_okhttp() : null;
        } else {
            ISpan parentSpan;
            okHttpEvent = null;
            ISpan iSpan = parentSpan = Platform.isAndroid() ? (ISpan)this.hub.getTransaction() : this.hub.getSpan();
            span = iSpan != null ? iSpan.startChild("http.client", method + ' ' + url) : null;
        }
        long startTimestamp = CurrentDateProvider.getInstance().getCurrentTimeMillis();
        ISpan iSpan = span;
        Object object = iSpan != null ? iSpan.getSpanContext() : null;
        if (object != null) {
            object.setOrigin("auto.http.okhttp");
        }
        urlDetails2.applyToSpan(span);
        boolean isFromEventListener = okHttpEvent != null;
        Response response = null;
        Integer code = null;
        try {
            Request.Builder requestBuilder = request.newBuilder();
            TracingUtils.TracingHeaders tracingHeaders = TracingUtils.traceIfAllowed((IHub)this.hub, (String)request.url().toString(), (List)request.headers("baggage"), (ISpan)span);
            if (tracingHeaders != null) {
                TracingUtils.TracingHeaders tracingHeaders2 = tracingHeaders;
                boolean bl = false;
                String string2 = tracingHeaders2.getSentryTraceHeader().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tracingHeaders.sentryTraceHeader.name");
                String string3 = tracingHeaders2.getSentryTraceHeader().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tracingHeaders.sentryTraceHeader.value");
                requestBuilder.addHeader(string2, string3);
                BaggageHeader baggageHeader = tracingHeaders2.getBaggageHeader();
                if (baggageHeader != null) {
                    BaggageHeader it = baggageHeader;
                    boolean bl2 = false;
                    requestBuilder.removeHeader("baggage");
                    String string4 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.name");
                    String string5 = it.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.value");
                    requestBuilder.addHeader(string4, string5);
                }
            }
            request = requestBuilder.build();
            response = chain.proceed(request);
            code = response.code();
            ISpan iSpan2 = span;
            if (iSpan2 != null) {
                iSpan2.setData("http.response.status_code", (Object)code);
            }
            ISpan iSpan3 = span;
            if (iSpan3 != null) {
                iSpan3.setStatus(SpanStatus.fromHttpStatusCode((int)code));
            }
            if (this.shouldCaptureClientError(request, response)) {
                if (isFromEventListener && okHttpEvent != null) {
                    okHttpEvent.setClientErrorResponse(response);
                } else {
                    SentryOkHttpUtils.INSTANCE.captureClientError$sentry_okhttp(this.hub, request, response);
                }
            }
            tracingHeaders = response;
            this.finishSpan(span, request, response, isFromEventListener);
            if (!isFromEventListener) {
                this.sendBreadcrumb(request, code, response, startTimestamp);
            }
            return tracingHeaders;
        }
        catch (IOException e) {
            try {
                ISpan iSpan4 = span;
                if (iSpan4 != null) {
                    ISpan iSpan5;
                    ISpan $this$intercept_u24lambda_u242 = iSpan5 = iSpan4;
                    boolean bl = false;
                    $this$intercept_u24lambda_u242.setThrowable((Throwable)e);
                    $this$intercept_u24lambda_u242.setStatus(SpanStatus.INTERNAL_ERROR);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.finishSpan(span, request, response, isFromEventListener);
                if (!isFromEventListener) {
                    this.sendBreadcrumb(request, code, response, startTimestamp);
                }
                throw throwable;
            }
        }
    }

    private final void sendBreadcrumb(Request request, Integer code, Response response, long startTimestamp) {
        Hint hint;
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.url().toString(), (String)request.method(), (Integer)code);
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"http(request.url.toString(), request.method, code)");
        Breadcrumb breadcrumb2 = breadcrumb;
        RequestBody requestBody = request.body();
        this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
            final /* synthetic */ Breadcrumb $breadcrumb;
            {
                this.$breadcrumb = $breadcrumb;
                super(1);
            }

            public final void invoke(long it) {
                this.$breadcrumb.setData("http.request_content_length", (Object)it);
            }
        }));
        Hint it = hint = new Hint();
        boolean bl = false;
        it.set("okHttp:request", (Object)request);
        Hint hint2 = hint;
        Response response2 = response;
        if (response2 != null) {
            it = response2;
            boolean bl2 = false;
            ResponseBody responseBody = it.body();
            this.ifHasValidLength(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                final /* synthetic */ Breadcrumb $breadcrumb;
                {
                    this.$breadcrumb = $breadcrumb;
                    super(1);
                }

                public final void invoke(long responseBodySize) {
                    this.$breadcrumb.setData("http.response_content_length", (Object)responseBodySize);
                }
            }));
            hint2.set("okHttp:response", (Object)it);
        }
        breadcrumb2.setData("http.start_timestamp", (Object)startTimestamp);
        breadcrumb2.setData("http.end_timestamp", (Object)CurrentDateProvider.getInstance().getCurrentTimeMillis());
        this.hub.addBreadcrumb(breadcrumb2, hint2);
    }

    private final void finishSpan(ISpan span, Request request, Response response, boolean isFromEventListener) {
        if (span == null) {
            return;
        }
        if (this.beforeSpan != null) {
            ISpan result = this.beforeSpan.execute(span, request, response);
            if (result == null) {
                span.getSpanContext().setSampled(Boolean.valueOf(false));
            }
            if (!isFromEventListener) {
                span.finish();
            }
        } else if (!isFromEventListener) {
            span.finish();
        }
    }

    private final void ifHasValidLength(Long $this$ifHasValidLength, Function1<? super Long, Unit> fn) {
        if ($this$ifHasValidLength != null) {
            long l = -1L;
            if ($this$ifHasValidLength != l) {
                fn.invoke((Object)$this$ifHasValidLength);
            }
        }
    }

    private final boolean shouldCaptureClientError(Request request, Response response) {
        if (!this.captureFailedRequests || !this.containsStatusCode(response.code())) {
            return false;
        }
        return PropagationTargetsUtils.contain(this.failedRequestTargets, (String)request.url().toString());
    }

    private final boolean containsStatusCode(int statusCode) {
        for (HttpStatusCodeRange item : this.failedRequestStatusCodes) {
            if (!item.isInRange(statusCode)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "", "execute", "Lio/sentry/ISpan;", "span", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "sentry-okhttp"})
    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull Request var2, @Nullable Response var3);
    }
}

