/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.log4j2;

import io.sentry.Breadcrumb;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.ITransportFactory;
import io.sentry.InitPriority;
import io.sentry.ScopesAdapter;
import io.sentry.Sentry;
import io.sentry.SentryAttribute;
import io.sentry.SentryAttributes;
import io.sentry.SentryEvent;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryLogLevel;
import io.sentry.SentryOptions;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.logger.SentryLogParameters;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Message;
import io.sentry.protocol.SdkVersion;
import io.sentry.util.CollectionUtils;
import io.sentry.util.LoggerPropertiesUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Plugin(name="Sentry", category="Core", elementType="appender", printObject=true)
public class SentryAppender
extends AbstractAppender {
    public static final String MECHANISM_TYPE = "Log4j2SentryAppender";
    @Nullable
    private final String dsn;
    @Nullable
    private final ITransportFactory transportFactory;
    @NotNull
    private Level minimumBreadcrumbLevel = Level.INFO;
    @NotNull
    private Level minimumEventLevel = Level.ERROR;
    @NotNull
    private Level minimumLevel = Level.INFO;
    @Nullable
    private final Boolean debug;
    @NotNull
    private final IScopes scopes;
    @Nullable
    private final List<String> contextTags;

    @Deprecated
    public SentryAppender(@NotNull String name, @Nullable Filter filter, @Nullable String dsn, @Nullable Level minimumBreadcrumbLevel, @Nullable Level minimumEventLevel, @Nullable Boolean debug, @Nullable ITransportFactory transportFactory, @NotNull IScopes scopes, @Nullable String[] contextTags) {
        this(name, filter, dsn, minimumBreadcrumbLevel, minimumEventLevel, null, debug, transportFactory, scopes, contextTags);
    }

    public SentryAppender(@NotNull String name, @Nullable Filter filter, @Nullable String dsn, @Nullable Level minimumBreadcrumbLevel, @Nullable Level minimumEventLevel, @Nullable Level minimumLevel, @Nullable Boolean debug, @Nullable ITransportFactory transportFactory, @NotNull IScopes scopes, @Nullable String[] contextTags) {
        super(name, filter, null, true, null);
        this.dsn = dsn;
        if (minimumBreadcrumbLevel != null) {
            this.minimumBreadcrumbLevel = minimumBreadcrumbLevel;
        }
        if (minimumEventLevel != null) {
            this.minimumEventLevel = minimumEventLevel;
        }
        if (minimumLevel != null) {
            this.minimumLevel = minimumLevel;
        }
        this.debug = debug;
        this.transportFactory = transportFactory;
        this.scopes = scopes;
        this.contextTags = contextTags != null ? Arrays.asList(contextTags) : null;
    }

    @PluginFactory
    @Nullable
    public static SentryAppender createAppender(@PluginAttribute(value="name") @Nullable String name, @PluginAttribute(value="minimumBreadcrumbLevel") @Nullable Level minimumBreadcrumbLevel, @PluginAttribute(value="minimumEventLevel") @Nullable Level minimumEventLevel, @PluginAttribute(value="minimumLevel") @Nullable Level minimumLevel, @PluginAttribute(value="dsn") @Nullable String dsn, @PluginAttribute(value="debug") @Nullable Boolean debug, @PluginElement(value="filter") @Nullable Filter filter, @PluginAttribute(value="contextTags") @Nullable String contextTags) {
        if (name == null) {
            LOGGER.error("No name provided for SentryAppender");
            return null;
        }
        return new SentryAppender(name, filter, dsn, minimumBreadcrumbLevel, minimumEventLevel, minimumLevel, debug, null, (IScopes)ScopesAdapter.getInstance(), contextTags != null ? contextTags.split(",") : null);
    }

    public void start() {
        try {
            Sentry.init(options -> {
                options.setEnableExternalConfiguration(true);
                options.setInitPriority(InitPriority.LOWEST);
                options.setDsn(this.dsn);
                if (this.debug != null) {
                    options.setDebug(this.debug.booleanValue());
                }
                options.setSentryClientName("sentry.java.log4j2/8.27.0");
                options.setSdkVersion(this.createSdkVersion(options));
                if (this.contextTags != null) {
                    for (String contextTag : this.contextTags) {
                        options.addContextTag(contextTag);
                    }
                }
                Optional.ofNullable(this.transportFactory).ifPresent(arg_0 -> ((SentryOptions)options).setTransportFactory(arg_0));
            });
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to init Sentry during appender initialization: " + e.getMessage());
        }
        this.addPackageAndIntegrationInfo();
        super.start();
    }

    public void append(@NotNull LogEvent eventObject) {
        Hint hint;
        if (this.scopes.getOptions().getLogs().isEnabled() && eventObject.getLevel().isMoreSpecificThan(this.minimumLevel)) {
            this.captureLog(eventObject);
        }
        if (eventObject.getLevel().isMoreSpecificThan(this.minimumEventLevel)) {
            hint = new Hint();
            hint.set("syntheticException", (Object)eventObject);
            this.scopes.captureEvent(this.createEvent(eventObject), hint);
        }
        if (eventObject.getLevel().isMoreSpecificThan(this.minimumBreadcrumbLevel)) {
            hint = new Hint();
            hint.set("log4j:logEvent", (Object)eventObject);
            this.scopes.addBreadcrumb(this.createBreadcrumb(eventObject), hint);
        }
    }

    protected void captureLog(@NotNull LogEvent loggingEvent) {
        @NotNull SentryLogLevel sentryLevel = SentryAppender.toSentryLogLevel(loggingEvent.getLevel());
        @Nullable Object[] arguments = loggingEvent.getMessage().getParameters();
        @NotNull SentryAttributes attributes = SentryAttributes.of((SentryAttribute[])new SentryAttribute[0]);
        @Nullable String nonFormattedMessage = loggingEvent.getMessage().getFormat();
        @NotNull String formattedMessage = loggingEvent.getMessage().getFormattedMessage();
        if (nonFormattedMessage != null && !formattedMessage.equals(nonFormattedMessage)) {
            attributes.add(SentryAttribute.stringAttribute((String)"sentry.message.template", (String)nonFormattedMessage));
        }
        @NotNull Map contextData = loggingEvent.getContextData().toMap();
        @NotNull List contextTags = ScopesAdapter.getInstance().getOptions().getContextTags();
        LoggerPropertiesUtil.applyPropertiesToAttributes((SentryAttributes)attributes, (List)contextTags, (Map)contextData);
        @NotNull SentryLogParameters params = SentryLogParameters.create((SentryAttributes)attributes);
        params.setOrigin("auto.log.log4j2");
        Sentry.logger().log(sentryLevel, params, formattedMessage, arguments);
    }

    @NotNull
    protected SentryEvent createEvent(@NotNull LogEvent loggingEvent) {
        Map contextData;
        SentryEvent event = new SentryEvent(DateUtils.getDateTime((long)loggingEvent.getTimeMillis()));
        Message message = new Message();
        message.setMessage(loggingEvent.getMessage().getFormat());
        message.setFormatted(loggingEvent.getMessage().getFormattedMessage());
        message.setParams(this.toParams(loggingEvent.getMessage().getParameters()));
        event.setMessage(message);
        event.setLogger(loggingEvent.getLoggerName());
        event.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        ThrowableProxy throwableInformation = loggingEvent.getThrownProxy();
        if (throwableInformation != null) {
            Mechanism mechanism = new Mechanism();
            mechanism.setType(MECHANISM_TYPE);
            ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism, throwableInformation.getThrowable(), Thread.currentThread());
            event.setThrowable((Throwable)mechanismException);
        }
        if (loggingEvent.getThreadName() != null) {
            event.setExtra("thread_name", (Object)loggingEvent.getThreadName());
        }
        if (loggingEvent.getMarker() != null) {
            event.setExtra("marker", (Object)loggingEvent.getMarker().toString());
        }
        if (!(contextData = CollectionUtils.filterMapEntries((Map)loggingEvent.getContextData().toMap(), entry -> entry.getValue() != null)).isEmpty()) {
            List contextTags = this.scopes.getOptions().getContextTags();
            LoggerPropertiesUtil.applyPropertiesToEvent((SentryEvent)event, (List)contextTags, (Map)contextData, (String)"Context Data");
        }
        return event;
    }

    @NotNull
    private List<String> toParams(@Nullable Object[] arguments) {
        if (arguments != null) {
            return Arrays.stream(arguments).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    protected Breadcrumb createBreadcrumb(@NotNull LogEvent loggingEvent) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        breadcrumb.setCategory(loggingEvent.getLoggerName());
        breadcrumb.setMessage(loggingEvent.getMessage().getFormattedMessage());
        return breadcrumb;
    }

    @NotNull
    private static SentryLevel formatLevel(@NotNull Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return SentryLevel.FATAL;
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return SentryLevel.ERROR;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return SentryLevel.WARNING;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return SentryLevel.INFO;
        }
        return SentryLevel.DEBUG;
    }

    @NotNull
    private static SentryLogLevel toSentryLogLevel(@NotNull Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return SentryLogLevel.FATAL;
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return SentryLogLevel.ERROR;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return SentryLogLevel.WARN;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return SentryLogLevel.INFO;
        }
        if (level.isMoreSpecificThan(Level.DEBUG)) {
            return SentryLogLevel.DEBUG;
        }
        return SentryLogLevel.TRACE;
    }

    @NotNull
    private SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
        SdkVersion sdkVersion = sentryOptions.getSdkVersion();
        String name = "sentry.java.log4j2";
        String version = "8.27.0";
        sdkVersion = SdkVersion.updateSdkVersion((SdkVersion)sdkVersion, (String)"sentry.java.log4j2", (String)"8.27.0");
        return sdkVersion;
    }

    private void addPackageAndIntegrationInfo() {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Log4j");
    }

    static {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-log4j2", "8.27.0");
    }
}

