/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.log4j2;

import io.sentry.Breadcrumb;
import io.sentry.DateUtils;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.Sentry;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.protocol.Message;
import io.sentry.protocol.SdkVersion;
import io.sentry.transport.ITransport;
import io.sentry.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Plugin(name="Sentry", category="Core", elementType="appender", printObject=true)
public final class SentryAppender
extends AbstractAppender {
    @Nullable
    private final String dsn;
    @Nullable
    private final ITransport transport;
    @NotNull
    private Level minimumBreadcrumbLevel = Level.INFO;
    @NotNull
    private Level minimumEventLevel = Level.ERROR;
    @NotNull
    private final IHub hub;

    public SentryAppender(@NotNull String name, @Nullable Filter filter, @Nullable String dsn, @Nullable Level minimumBreadcrumbLevel, @Nullable Level minimumEventLevel, @Nullable ITransport transport, @NotNull IHub hub) {
        super(name, filter, null, true, null);
        this.dsn = dsn;
        if (minimumBreadcrumbLevel != null) {
            this.minimumBreadcrumbLevel = minimumBreadcrumbLevel;
        }
        if (minimumEventLevel != null) {
            this.minimumEventLevel = minimumEventLevel;
        }
        this.transport = transport;
        this.hub = hub;
    }

    @PluginFactory
    public static SentryAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="minimumBreadcrumbLevel") Level minimumBreadcrumbLevel, @PluginAttribute(value="minimumEventLevel") Level minimumEventLevel, @PluginAttribute(value="dsn") String dsn, @PluginElement(value="filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for SentryAppender");
            return null;
        }
        return new SentryAppender(name, filter, dsn, minimumBreadcrumbLevel, minimumEventLevel, null, (IHub)HubAdapter.getInstance());
    }

    public void start() {
        if (!Sentry.isEnabled()) {
            try {
                Sentry.init(options -> {
                    options.setEnableExternalConfiguration(true);
                    options.setDsn(this.dsn);
                    options.setSentryClientName("sentry.java.log4j2");
                    options.setSdkVersion(this.createSdkVersion(options));
                    Optional.ofNullable(this.transport).ifPresent(arg_0 -> ((SentryOptions)options).setTransport(arg_0));
                });
            }
            catch (IllegalArgumentException e) {
                LOGGER.info("Failed to init Sentry during appender initialization: " + e.getMessage());
            }
        }
        super.start();
    }

    public void append(@NotNull LogEvent eventObject) {
        if (eventObject.getLevel().isMoreSpecificThan(this.minimumEventLevel)) {
            this.hub.captureEvent(this.createEvent(eventObject));
        }
        if (eventObject.getLevel().isMoreSpecificThan(this.minimumBreadcrumbLevel)) {
            this.hub.addBreadcrumb(this.createBreadcrumb(eventObject));
        }
    }

    @NotNull
    final SentryEvent createEvent(@NotNull LogEvent loggingEvent) {
        Map contextData;
        SentryEvent event = new SentryEvent(DateUtils.getDateTime((Date)new Date(loggingEvent.getTimeMillis())));
        Message message = new Message();
        message.setMessage(loggingEvent.getMessage().getFormat());
        message.setFormatted(loggingEvent.getMessage().getFormattedMessage());
        message.setParams(this.toParams(loggingEvent.getMessage().getParameters()));
        event.setMessage(message);
        event.setLogger(loggingEvent.getLoggerName());
        event.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        ThrowableProxy throwableInformation = loggingEvent.getThrownProxy();
        if (throwableInformation != null) {
            event.setThrowable(throwableInformation.getThrowable());
        }
        if (loggingEvent.getThreadName() != null) {
            event.setExtra("thread_name", (Object)loggingEvent.getThreadName());
        }
        if (!(contextData = CollectionUtils.shallowCopy((Map)loggingEvent.getContextData().toMap())).isEmpty()) {
            event.getContexts().put((Object)"Context Data", (Object)contextData);
        }
        return event;
    }

    @NotNull
    private List<String> toParams(@Nullable Object[] arguments) {
        if (arguments != null) {
            return Arrays.stream(arguments).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    private Breadcrumb createBreadcrumb(@NotNull LogEvent loggingEvent) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setLevel(SentryAppender.formatLevel(loggingEvent.getLevel()));
        breadcrumb.setCategory(loggingEvent.getLoggerName());
        breadcrumb.setMessage(loggingEvent.getMessage().getFormattedMessage());
        return breadcrumb;
    }

    @NotNull
    private static SentryLevel formatLevel(@NotNull Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return SentryLevel.FATAL;
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return SentryLevel.ERROR;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return SentryLevel.WARNING;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return SentryLevel.INFO;
        }
        return SentryLevel.DEBUG;
    }

    @NotNull
    private SdkVersion createSdkVersion(@NotNull SentryOptions sentryOptions) {
        SdkVersion sdkVersion = sentryOptions.getSdkVersion();
        if (sdkVersion == null) {
            sdkVersion = new SdkVersion();
        }
        sdkVersion.setName("sentry.java.log4j2");
        String version = "3.1.3";
        sdkVersion.setVersion("3.1.3");
        sdkVersion.addPackage("maven:sentry-log4j2", "3.1.3");
        return sdkVersion;
    }
}

