/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.graphql;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.language.AstPrinter;
import graphql.language.Node;
import graphql.schema.DataFetchingEnvironment;
import io.sentry.Hint;
import io.sentry.IScopes;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Request;
import io.sentry.protocol.Response;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExceptionReporter {
    private final boolean captureRequestBodyForNonSubscriptions;
    @NotNull
    private static final String MECHANISM_TYPE = "GraphqlInstrumentation";

    public ExceptionReporter(boolean captureRequestBodyForNonSubscriptions) {
        this.captureRequestBodyForNonSubscriptions = captureRequestBodyForNonSubscriptions;
    }

    public void captureThrowable(@NotNull Throwable throwable, @NotNull ExceptionDetails exceptionDetails, @Nullable ExecutionResult result) {
        @NotNull IScopes scopes = exceptionDetails.getScopes();
        @NotNull Mechanism mechanism = new Mechanism();
        mechanism.setType(MECHANISM_TYPE);
        mechanism.setHandled(Boolean.valueOf(false));
        @NotNull ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism, throwable, Thread.currentThread());
        @NotNull SentryEvent event = new SentryEvent((Throwable)mechanismException);
        event.setLevel(SentryLevel.FATAL);
        @NotNull Hint hint = new Hint();
        this.setRequestDetailsOnEvent(scopes, exceptionDetails, event);
        if (result != null && this.isAllowedToAttachBody(scopes)) {
            @NotNull Response response = new Response();
            @NotNull Map responseBody = result.toSpecification();
            response.setData((Object)responseBody);
            event.getContexts().setResponse(response);
        }
        scopes.captureEvent(event, hint);
    }

    private boolean isAllowedToAttachBody(@NotNull IScopes scopes) {
        @NotNull SentryOptions options = scopes.getOptions();
        return options.isSendDefaultPii() && !SentryOptions.RequestSize.NONE.equals((Object)options.getMaxRequestBodySize());
    }

    private void setRequestDetailsOnEvent(@NotNull IScopes scopes, @NotNull ExceptionDetails exceptionDetails, @NotNull SentryEvent event) {
        scopes.configureScope(scope -> {
            @Nullable Request scopeRequest = scope.getRequest();
            @NotNull Request request = scopeRequest == null ? new Request() : scopeRequest;
            this.setDetailsOnRequest(scopes, exceptionDetails, request);
            event.setRequest(request);
        });
    }

    private void setDetailsOnRequest(@NotNull IScopes scopes, @NotNull ExceptionDetails exceptionDetails, @NotNull Request request) {
        request.setApiTarget("graphql");
        if (this.isAllowedToAttachBody(scopes) && (exceptionDetails.isSubscription() || this.captureRequestBodyForNonSubscriptions)) {
            @NotNull HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("query", exceptionDetails.getQuery());
            @Nullable Map<String, Object> variables = exceptionDetails.getVariables();
            if (variables != null && !variables.isEmpty()) {
                data.put("variables", variables);
            }
            request.setData(data);
        }
    }

    public static final class ExceptionDetails {
        @NotNull
        private final IScopes scopes;
        @Nullable
        private final InstrumentationExecutionParameters instrumentationExecutionParameters;
        @Nullable
        private final DataFetchingEnvironment dataFetchingEnvironment;
        private final boolean isSubscription;

        public ExceptionDetails(@NotNull IScopes scopes, @Nullable InstrumentationExecutionParameters instrumentationExecutionParameters, boolean isSubscription) {
            this.scopes = scopes;
            this.instrumentationExecutionParameters = instrumentationExecutionParameters;
            this.dataFetchingEnvironment = null;
            this.isSubscription = isSubscription;
        }

        public ExceptionDetails(@NotNull IScopes scopes, @Nullable DataFetchingEnvironment dataFetchingEnvironment, boolean isSubscription) {
            this.scopes = scopes;
            this.dataFetchingEnvironment = dataFetchingEnvironment;
            this.instrumentationExecutionParameters = null;
            this.isSubscription = isSubscription;
        }

        @Nullable
        public String getQuery() {
            if (this.instrumentationExecutionParameters != null) {
                return this.instrumentationExecutionParameters.getQuery();
            }
            if (this.dataFetchingEnvironment != null) {
                return AstPrinter.printAst((Node)this.dataFetchingEnvironment.getDocument());
            }
            return null;
        }

        @Nullable
        public Map<String, Object> getVariables() {
            if (this.instrumentationExecutionParameters != null) {
                return this.instrumentationExecutionParameters.getVariables();
            }
            if (this.dataFetchingEnvironment != null) {
                return this.dataFetchingEnvironment.getVariables();
            }
            return null;
        }

        public boolean isSubscription() {
            return this.isSubscription;
        }

        @Deprecated
        @NotNull
        public IScopes getHub() {
            return this.scopes;
        }

        @NotNull
        public IScopes getScopes() {
            return this.scopes;
        }
    }
}

