/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.graphql;

import graphql.ErrorClassification;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import io.sentry.Breadcrumb;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.NoOpHub;
import io.sentry.Sentry;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SpanStatus;
import io.sentry.graphql.ExceptionReporter;
import io.sentry.graphql.GraphqlStringUtils;
import io.sentry.graphql.NoOpSubscriptionHandler;
import io.sentry.graphql.SentrySubscriptionHandler;
import io.sentry.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SentryInstrumentation
extends SimpleInstrumentation {
    @NotNull
    private static final List<String> ERROR_TYPES_HANDLED_BY_DATA_FETCHERS = Arrays.asList("INTERNAL_ERROR", "INTERNAL", "DataFetchingException");
    @NotNull
    public static final String SENTRY_HUB_CONTEXT_KEY = "sentry.hub";
    @NotNull
    public static final String SENTRY_EXCEPTIONS_CONTEXT_KEY = "sentry.exceptions";
    private static final String TRACE_ORIGIN = "auto.graphql.graphql";
    @Nullable
    private final BeforeSpanCallback beforeSpan;
    @NotNull
    private final SentrySubscriptionHandler subscriptionHandler;
    @NotNull
    private final ExceptionReporter exceptionReporter;
    @NotNull
    private final List<String> ignoredErrorTypes;

    @Deprecated
    public SentryInstrumentation() {
        this(null, NoOpSubscriptionHandler.getInstance(), true);
    }

    @Deprecated
    public SentryInstrumentation(@Nullable IHub hub) {
        this(null, NoOpSubscriptionHandler.getInstance(), true);
    }

    @Deprecated
    public SentryInstrumentation(@Nullable BeforeSpanCallback beforeSpan) {
        this(beforeSpan, NoOpSubscriptionHandler.getInstance(), true);
    }

    @Deprecated
    public SentryInstrumentation(@Nullable IHub hub, @Nullable BeforeSpanCallback beforeSpan) {
        this(beforeSpan, NoOpSubscriptionHandler.getInstance(), true);
    }

    public SentryInstrumentation(@Nullable BeforeSpanCallback beforeSpan, @NotNull SentrySubscriptionHandler subscriptionHandler, boolean captureRequestBodyForNonSubscriptions) {
        this(beforeSpan, subscriptionHandler, new ExceptionReporter(captureRequestBodyForNonSubscriptions), new ArrayList<String>());
    }

    public SentryInstrumentation(@Nullable BeforeSpanCallback beforeSpan, @NotNull SentrySubscriptionHandler subscriptionHandler, boolean captureRequestBodyForNonSubscriptions, @NotNull List<String> ignoredErrorTypes) {
        this(beforeSpan, subscriptionHandler, new ExceptionReporter(captureRequestBodyForNonSubscriptions), ignoredErrorTypes);
    }

    @TestOnly
    public SentryInstrumentation(@Nullable BeforeSpanCallback beforeSpan, @NotNull SentrySubscriptionHandler subscriptionHandler, @NotNull ExceptionReporter exceptionReporter, @NotNull List<String> ignoredErrorTypes) {
        this.beforeSpan = beforeSpan;
        this.subscriptionHandler = subscriptionHandler;
        this.exceptionReporter = exceptionReporter;
        this.ignoredErrorTypes = ignoredErrorTypes;
        SentryIntegrationPackageStorage.getInstance().addIntegration("GraphQL");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-graphql", "7.2.0");
    }

    public SentryInstrumentation(@NotNull SentrySubscriptionHandler subscriptionHandler, boolean captureRequestBodyForNonSubscriptions) {
        this(null, subscriptionHandler, captureRequestBodyForNonSubscriptions);
    }

    @NotNull
    public InstrumentationState createState() {
        return new TracingState();
    }

    @NotNull
    public InstrumentationContext<ExecutionResult> beginExecution(@NotNull InstrumentationExecutionParameters parameters) {
        TracingState tracingState = (TracingState)parameters.getInstrumentationState();
        @NotNull IHub currentHub = Sentry.getCurrentHub();
        tracingState.setTransaction(currentHub.getSpan());
        parameters.getGraphQLContext().put((Object)SENTRY_HUB_CONTEXT_KEY, (Object)currentHub);
        return super.beginExecution(parameters);
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        return super.instrumentExecutionResult(executionResult, parameters).whenComplete((result, exception) -> {
            if (result != null) {
                List errors;
                @Nullable GraphQLContext graphQLContext = parameters.getGraphQLContext();
                if (graphQLContext != null) {
                    @NotNull List exceptions = (List)graphQLContext.getOrDefault((Object)SENTRY_EXCEPTIONS_CONTEXT_KEY, new CopyOnWriteArrayList());
                    for (Throwable throwable : exceptions) {
                        this.exceptionReporter.captureThrowable(throwable, new ExceptionReporter.ExceptionDetails(this.hubFromContext(graphQLContext), parameters, false), (ExecutionResult)result);
                    }
                }
                if ((errors = result.getErrors()) != null) {
                    for (GraphQLError error : errors) {
                        String errorType = this.getErrorType(error);
                        if (this.isIgnored(errorType)) continue;
                        this.exceptionReporter.captureThrowable(new RuntimeException(error.getMessage()), new ExceptionReporter.ExceptionDetails(this.hubFromContext(graphQLContext), parameters, false), (ExecutionResult)result);
                    }
                }
            }
            if (exception != null) {
                this.exceptionReporter.captureThrowable((Throwable)exception, new ExceptionReporter.ExceptionDetails(this.hubFromContext(parameters.getGraphQLContext()), parameters, false), null);
            }
        });
    }

    private boolean isIgnored(@Nullable String errorType) {
        if (errorType == null) {
            return false;
        }
        return ERROR_TYPES_HANDLED_BY_DATA_FETCHERS.contains(errorType) || this.ignoredErrorTypes.contains(errorType);
    }

    @Nullable
    private String getErrorType(@Nullable GraphQLError error) {
        if (error == null) {
            return null;
        }
        @Nullable ErrorClassification errorType = error.getErrorType();
        if (errorType != null) {
            return errorType.toString();
        }
        @Nullable Map extensions = error.getExtensions();
        if (extensions != null) {
            return StringUtils.toString(extensions.get("errorType"));
        }
        return null;
    }

    @NotNull
    public InstrumentationContext<ExecutionResult> beginExecuteOperation(@NotNull InstrumentationExecuteOperationParameters parameters) {
        OperationDefinition operationDefinition;
        @Nullable ExecutionContext executionContext = parameters.getExecutionContext();
        if (executionContext != null && (operationDefinition = executionContext.getOperationDefinition()) != null) {
            // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable OperationDefinition.Operation operation = operationDefinition.getOperation();
            @Nullable String operationType = operation == null ? null : operation.name().toLowerCase(Locale.ROOT);
            this.hubFromContext(parameters.getExecutionContext().getGraphQLContext()).addBreadcrumb(Breadcrumb.graphqlOperation((String)operationDefinition.getName(), (String)operationType, (String)StringUtils.toString((Object)executionContext.getExecutionId())));
        }
        return super.beginExecuteOperation(parameters);
    }

    @NotNull
    private IHub hubFromContext(@Nullable GraphQLContext context) {
        if (context == null) {
            return NoOpHub.getInstance();
        }
        return (IHub)context.getOrDefault((Object)SENTRY_HUB_CONTEXT_KEY, (Object)NoOpHub.getInstance());
    }

    @NotNull
    public DataFetcher<?> instrumentDataFetcher(@NotNull DataFetcher<?> dataFetcher, @NotNull InstrumentationFieldFetchParameters parameters) {
        if (parameters.isTrivialDataFetcher()) {
            return dataFetcher;
        }
        return environment -> {
            TracingState tracingState;
            ISpan transaction;
            @Nullable ExecutionStepInfo executionStepInfo = environment.getExecutionStepInfo();
            if (executionStepInfo != null) {
                this.hubFromContext(parameters.getExecutionContext().getGraphQLContext()).addBreadcrumb(Breadcrumb.graphqlDataFetcher((String)StringUtils.toString((Object)executionStepInfo.getPath()), (String)GraphqlStringUtils.fieldToString(executionStepInfo.getField()), (String)GraphqlStringUtils.typeToString(executionStepInfo.getType()), (String)GraphqlStringUtils.objectTypeToString(executionStepInfo.getObjectType())));
            }
            if ((transaction = (tracingState = (TracingState)parameters.getInstrumentationState()).getTransaction()) != null) {
                ISpan span = this.createSpan(transaction, parameters);
                try {
                    @Nullable Object tmpResult = dataFetcher.get(environment);
                    @Nullable Object result = this.maybeCallSubscriptionHandler(parameters, environment, tmpResult);
                    if (result instanceof CompletableFuture) {
                        ((CompletableFuture)result).whenComplete((r, ex) -> {
                            if (ex != null) {
                                span.setThrowable(ex);
                                span.setStatus(SpanStatus.INTERNAL_ERROR);
                            } else {
                                span.setStatus(SpanStatus.OK);
                            }
                            this.finish(span, environment, r);
                        });
                    } else {
                        span.setStatus(SpanStatus.OK);
                        this.finish(span, environment, result);
                    }
                    return result;
                }
                catch (Throwable e) {
                    span.setThrowable(e);
                    span.setStatus(SpanStatus.INTERNAL_ERROR);
                    this.finish(span, environment);
                    throw e;
                }
            }
            Object result = dataFetcher.get(environment);
            return this.maybeCallSubscriptionHandler(parameters, environment, result);
        };
    }

    @Nullable
    private Object maybeCallSubscriptionHandler(@NotNull InstrumentationFieldFetchParameters parameters, @NotNull DataFetchingEnvironment environment, @Nullable Object tmpResult) {
        if (tmpResult == null) {
            return null;
        }
        if (OperationDefinition.Operation.SUBSCRIPTION.equals((Object)environment.getOperationDefinition().getOperation())) {
            return this.subscriptionHandler.onSubscriptionResult(tmpResult, this.hubFromContext(environment.getGraphQlContext()), this.exceptionReporter, parameters);
        }
        return tmpResult;
    }

    private void finish(@NotNull ISpan span, @NotNull DataFetchingEnvironment environment, @Nullable Object result) {
        if (this.beforeSpan != null) {
            ISpan newSpan = this.beforeSpan.execute(span, environment, result);
            if (newSpan == null) {
                span.getSpanContext().setSampled(Boolean.valueOf(false));
            } else {
                newSpan.finish();
            }
        } else {
            span.finish();
        }
    }

    private void finish(@NotNull ISpan span, @NotNull DataFetchingEnvironment environment) {
        this.finish(span, environment, null);
    }

    @NotNull
    private ISpan createSpan(@NotNull ISpan transaction, @NotNull InstrumentationFieldFetchParameters parameters) {
        GraphQLOutputType type = parameters.getExecutionStepInfo().getParent().getType();
        GraphQLObjectType parent = type instanceof GraphQLNonNull ? (GraphQLObjectType)((GraphQLNonNull)type).getWrappedType() : (GraphQLObjectType)type;
        @NotNull ISpan span = transaction.startChild("graphql", parent.getName() + "." + parameters.getExecutionStepInfo().getPath().getSegmentName());
        span.getSpanContext().setOrigin(TRACE_ORIGIN);
        return span;
    }

    @FunctionalInterface
    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull DataFetchingEnvironment var2, @Nullable Object var3);
    }

    static final class TracingState
    implements InstrumentationState {
        @Nullable
        private ISpan transaction;

        TracingState() {
        }

        @Nullable
        public ISpan getTransaction() {
            return this.transaction;
        }

        public void setTransaction(@Nullable ISpan transaction) {
            this.transaction = transaction;
        }
    }
}

