/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.graphql;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryInstrumentation
extends SimpleInstrumentation {
    @NotNull
    private final IHub hub;
    @Nullable
    private final BeforeSpanCallback beforeSpan;

    public SentryInstrumentation(@NotNull IHub hub, @Nullable BeforeSpanCallback beforeSpan) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.beforeSpan = beforeSpan;
        SentryIntegrationPackageStorage.getInstance().addIntegration("GraphQL");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-graphql", "6.17.0");
    }

    public SentryInstrumentation(@Nullable BeforeSpanCallback beforeSpan) {
        this((IHub)HubAdapter.getInstance(), beforeSpan);
    }

    public SentryInstrumentation(@NotNull IHub hub) {
        this(hub, null);
    }

    public SentryInstrumentation() {
        this((IHub)HubAdapter.getInstance());
    }

    @NotNull
    public InstrumentationState createState() {
        return new TracingState();
    }

    @NotNull
    public InstrumentationContext<ExecutionResult> beginExecution(@NotNull InstrumentationExecutionParameters parameters) {
        TracingState tracingState = (TracingState)parameters.getInstrumentationState();
        tracingState.setTransaction(this.hub.getSpan());
        return super.beginExecution(parameters);
    }

    @NotNull
    public DataFetcher<?> instrumentDataFetcher(@NotNull DataFetcher<?> dataFetcher, @NotNull InstrumentationFieldFetchParameters parameters) {
        if (parameters.isTrivialDataFetcher()) {
            return dataFetcher;
        }
        return environment -> {
            TracingState tracingState = (TracingState)parameters.getInstrumentationState();
            ISpan transaction = tracingState.getTransaction();
            if (transaction != null) {
                ISpan span = this.createSpan(transaction, parameters);
                try {
                    Object result = dataFetcher.get(environment);
                    if (result instanceof CompletableFuture) {
                        ((CompletableFuture)result).whenComplete((r, ex) -> {
                            if (ex != null) {
                                span.setThrowable(ex);
                                span.setStatus(SpanStatus.INTERNAL_ERROR);
                            } else {
                                span.setStatus(SpanStatus.OK);
                            }
                            this.finish(span, environment, r);
                        });
                    } else {
                        span.setStatus(SpanStatus.OK);
                        this.finish(span, environment, result);
                    }
                    return result;
                }
                catch (Throwable e) {
                    span.setThrowable(e);
                    span.setStatus(SpanStatus.INTERNAL_ERROR);
                    this.finish(span, environment);
                    throw e;
                }
            }
            return dataFetcher.get(environment);
        };
    }

    private void finish(@NotNull ISpan span, @NotNull DataFetchingEnvironment environment, @Nullable Object result) {
        if (this.beforeSpan != null) {
            ISpan newSpan = this.beforeSpan.execute(span, environment, result);
            if (newSpan == null) {
                span.getSpanContext().setSampled(Boolean.valueOf(false));
            } else {
                newSpan.finish();
            }
        } else {
            span.finish();
        }
    }

    private void finish(@NotNull ISpan span, @NotNull DataFetchingEnvironment environment) {
        this.finish(span, environment, null);
    }

    @NotNull
    private ISpan createSpan(@NotNull ISpan transaction, @NotNull InstrumentationFieldFetchParameters parameters) {
        GraphQLOutputType type = parameters.getExecutionStepInfo().getParent().getType();
        GraphQLObjectType parent = type instanceof GraphQLNonNull ? (GraphQLObjectType)((GraphQLNonNull)type).getWrappedType() : (GraphQLObjectType)type;
        return transaction.startChild("graphql", parent.getName() + "." + parameters.getExecutionStepInfo().getPath().getSegmentName());
    }

    @FunctionalInterface
    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull DataFetchingEnvironment var2, @Nullable Object var3);
    }

    static final class TracingState
    implements InstrumentationState {
        @Nullable
        private ISpan transaction;

        TracingState() {
        }

        @Nullable
        public ISpan getTransaction() {
            return this.transaction;
        }

        public void setTransaction(@Nullable ISpan transaction) {
            this.transaction = transaction;
        }
    }
}

