/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.AsyncConnectionFactory;
import io.sentry.core.Breadcrumb;
import io.sentry.core.EventProcessor;
import io.sentry.core.HttpTransportFactory;
import io.sentry.core.ISentryClient;
import io.sentry.core.Scope;
import io.sentry.core.SentryEnvelope;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.Session;
import io.sentry.core.cache.DiskCache;
import io.sentry.core.cache.SessionCache;
import io.sentry.core.hints.DiskFlushNotification;
import io.sentry.core.hints.SessionEndHint;
import io.sentry.core.hints.SessionUpdateHint;
import io.sentry.core.protocol.SentryId;
import io.sentry.core.transport.Connection;
import io.sentry.core.transport.ITransport;
import io.sentry.core.transport.ITransportGate;
import io.sentry.core.util.ApplyScopeUtils;
import io.sentry.core.util.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryClient
implements ISentryClient {
    static final String SENTRY_PROTOCOL_VERSION = "7";
    private boolean enabled;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final Connection connection;
    @Nullable
    private final Random random;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    SentryClient(@NotNull SentryOptions options) {
        this(options, null);
    }

    public SentryClient(@NotNull SentryOptions options, @Nullable Connection connection) {
        ITransportGate transportGate;
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.enabled = true;
        ITransport transport = options.getTransport();
        if (transport == null) {
            transport = HttpTransportFactory.create(options);
            options.setTransport(transport);
        }
        if ((transportGate = options.getTransportGate()) == null) {
            transportGate = () -> true;
            options.setTransportGate(transportGate);
        }
        if (connection == null) {
            DiskCache cache = new DiskCache(options);
            SessionCache sessionCache = new SessionCache(options);
            connection = AsyncConnectionFactory.create(options, cache, sessionCache);
        }
        this.connection = connection;
        this.random = options.getSampleRate() == null ? null : new Random();
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Scope scope, @Nullable Object hint) {
        Objects.requireNonNull(event, "SentryEvent is required.");
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing event: %s", event.getEventId());
        if (ApplyScopeUtils.shouldApplyScopeData(hint)) {
            if ((event = this.applyScope(event, scope, hint)) == null) {
                return SentryId.EMPTY_ID;
            }
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying scope: %s", event.getEventId());
        }
        for (EventProcessor processor : this.options.getEventProcessors()) {
            event = processor.process(event, hint);
            if (event != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by processor: %s", processor.getClass().getName());
            break;
        }
        if (event == null) {
            return SentryId.EMPTY_ID;
        }
        this.updateSessionData(event, hint, scope);
        if (!this.sample()) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", event.getEventId());
            return SentryId.EMPTY_ID;
        }
        if ((event = this.executeBeforeSend(event, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by beforeSend", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        try {
            this.connection.send(event, hint);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Capturing event " + event.getEventId() + " failed.", e);
        }
        return event.getEventId();
    }

    void updateSessionData(@NotNull SentryEvent event, @Nullable Object hint, @Nullable Scope scope) {
        if (ApplyScopeUtils.shouldApplyScopeData(hint)) {
            if (scope != null) {
                scope.withSession(session -> {
                    if (session != null) {
                        Session.State status = null;
                        if (event.isCrashed()) {
                            status = Session.State.Crashed;
                        }
                        boolean crashedOrErrored = false;
                        if (Session.State.Crashed == status || event.isErrored()) {
                            crashedOrErrored = true;
                        }
                        String userAgent = null;
                        if (event.getRequest() != null && event.getRequest().getHeaders() != null && event.getRequest().getHeaders().containsKey("user-agent")) {
                            userAgent = event.getRequest().getHeaders().get("user-agent");
                        }
                        if (session.update(status, userAgent, crashedOrErrored)) {
                            Object sessionHint;
                            if (hint instanceof DiskFlushNotification) {
                                sessionHint = new SessionEndHint();
                                session.end();
                            } else {
                                sessionHint = new SessionUpdateHint();
                            }
                            this.captureSession(session, sessionHint);
                        }
                    } else {
                        this.options.getLogger().log(SentryLevel.INFO, "Session is null on scope.withSession", new Object[0]);
                    }
                });
            } else {
                this.options.getLogger().log(SentryLevel.INFO, "Scope is null on client.captureEvent", new Object[0]);
            }
        }
    }

    @Override
    @ApiStatus.Internal
    public void captureSession(@NotNull Session session, @Nullable Object hint) {
        SentryEnvelope envelope;
        Objects.requireNonNull(session, "Session is required.");
        if (session.getRelease() == null || session.getRelease().isEmpty()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Sessions can't be captured without setting a release.", new Object[0]);
            return;
        }
        try {
            envelope = SentryEnvelope.fromSession(this.options.getSerializer(), session, this.options.getSdkVersion());
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture session.", e);
            return;
        }
        this.captureEnvelope(envelope, hint);
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public SentryId captureEnvelope(@NotNull SentryEnvelope envelope, @Nullable Object hint) {
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        try {
            this.connection.send(envelope, hint);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope.", e);
            return SentryId.EMPTY_ID;
        }
        return envelope.getHeader().getEventId();
    }

    @Nullable
    private SentryEvent applyScope(@NotNull SentryEvent event, @Nullable Scope scope, @Nullable Object hint) {
        if (scope != null) {
            if (event.getTransaction() == null) {
                event.setTransaction(scope.getTransaction());
            }
            if (event.getUser() == null) {
                event.setUser(scope.getUser());
            }
            if (event.getFingerprints() == null) {
                event.setFingerprints(scope.getFingerprint());
            }
            if (event.getBreadcrumbs() == null) {
                event.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                event.getBreadcrumbs().addAll(scope.getBreadcrumbs());
            }
            if (event.getTags() == null) {
                event.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (event.getTags().containsKey(entry.getKey())) continue;
                    event.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (event.getExtras() == null) {
                event.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (event.getExtras().containsKey(entry.getKey())) continue;
                    event.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            if (scope.getLevel() != null) {
                event.setLevel(scope.getLevel());
            }
            for (EventProcessor eventProcessor : scope.getEventProcessors()) {
                event = eventProcessor.process(event, hint);
                if (event != null) continue;
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by scope processor: %s", eventProcessor.getClass().getName());
                break;
            }
        }
        return event;
    }

    @Nullable
    private SentryEvent executeBeforeSend(@NotNull SentryEvent event, @Nullable Object hint) {
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                event = beforeSend.execute(event, hint);
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", e);
                Breadcrumb breadcrumb = new Breadcrumb();
                breadcrumb.setMessage("BeforeSend callback failed.");
                breadcrumb.setCategory("SentryClient");
                breadcrumb.setLevel(SentryLevel.ERROR);
                breadcrumb.setData("sentry:message", e.getMessage());
                event.addBreadcrumb(breadcrumb);
            }
        }
        return event;
    }

    @Override
    public void close() {
        this.options.getLogger().log(SentryLevel.INFO, "Closing SentryClient.", new Object[0]);
        try {
            this.flush(this.options.getShutdownTimeout());
            this.connection.close();
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", e);
        }
        this.enabled = false;
    }

    @Override
    public void flush(long timeoutMillis) {
    }

    private boolean sample() {
        if (this.options.getSampleRate() != null && this.random != null) {
            double sampling = this.options.getSampleRate();
            return !(sampling < this.random.nextDouble());
        }
        return true;
    }
}

