/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.transport;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RetryingThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private final int maxQueueSize;
    private final AtomicInteger currentlyRunning;

    public RetryingThreadPoolExecutor(int corePoolSize, int maxQueueSize, @NotNull ThreadFactory threadFactory, @NotNull RejectedExecutionHandler rejectedExecutionHandler) {
        super(corePoolSize, threadFactory, rejectedExecutionHandler);
        this.maxQueueSize = maxQueueSize;
        this.currentlyRunning = new AtomicInteger();
    }

    @Override
    public Future<?> submit(@NotNull Runnable task) {
        if (this.isSchedulingAllowed()) {
            return super.submit(task);
        }
        return new CancelledFuture();
    }

    @Override
    protected void beforeExecute(@NotNull Thread t, @NotNull Runnable r) {
        try {
            super.beforeExecute(t, r);
        }
        finally {
            this.currentlyRunning.incrementAndGet();
        }
    }

    @Override
    protected void afterExecute(@NotNull Runnable r, @Nullable Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            this.currentlyRunning.decrementAndGet();
        }
    }

    private boolean isSchedulingAllowed() {
        return this.getQueue().size() + this.currentlyRunning.get() < this.maxQueueSize;
    }

    private static final class CancelledFuture<T>
    implements Future<T> {
        private CancelledFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() {
            throw new CancellationException();
        }

        @Override
        public T get(long timeout, @NotNull TimeUnit unit) {
            throw new CancellationException();
        }
    }
}

