/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DiagnosticLogger
implements ILogger {
    private final SentryOptions options;
    @Nullable
    private final ILogger logger;

    public DiagnosticLogger(SentryOptions options, @Nullable ILogger logger) {
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.logger = logger;
    }

    public boolean isEnabled(@Nullable SentryLevel level) {
        SentryLevel diagLevel = this.options.getDiagnosticLevel();
        if (level == null || diagLevel == null) {
            return false;
        }
        return this.options.isDebug() && level.ordinal() >= diagLevel.ordinal();
    }

    @Override
    public void log(@Nullable SentryLevel level, @Nullable String message, Object ... args) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, message, args);
        }
    }

    @Override
    public void log(@Nullable SentryLevel level, @Nullable String message, @Nullable Throwable throwable) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, message, throwable);
        }
    }

    @Override
    public void log(@Nullable SentryLevel level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        if (this.logger != null && this.isEnabled(level)) {
            this.logger.log(level, throwable, message, args);
        }
    }

    @Nullable
    public ILogger getLogger() {
        return this.logger;
    }
}

