/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.SentryStackTraceFactory;
import io.sentry.core.exception.ExceptionMechanismException;
import io.sentry.core.protocol.Mechanism;
import io.sentry.core.protocol.SentryException;
import io.sentry.core.protocol.SentryStackTrace;
import io.sentry.core.util.Objects;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SentryExceptionFactory {
    @NotNull
    private final SentryStackTraceFactory sentryStackTraceFactory;

    public SentryExceptionFactory(@NotNull SentryStackTraceFactory sentryStackTraceFactory) {
        this.sentryStackTraceFactory = Objects.requireNonNull(sentryStackTraceFactory, "The SentryStackTraceFactory is required.");
    }

    @NotNull
    List<SentryException> getSentryExceptions(@NotNull Throwable throwable) {
        return this.getSentryExceptions(this.extractExceptionQueue(throwable));
    }

    @NotNull
    private List<SentryException> getSentryExceptions(@NotNull Deque<SentryException> exceptions) {
        return new ArrayList<SentryException>(exceptions);
    }

    @NotNull
    private SentryException getSentryException(@NotNull Throwable throwable, @Nullable Mechanism exceptionMechanism, @Nullable Thread thread) {
        Package exceptionPackage = throwable.getClass().getPackage();
        String fullClassName = throwable.getClass().getName();
        SentryException exception = new SentryException();
        String exceptionMessage = throwable.getMessage();
        String exceptionClassName = exceptionPackage != null ? fullClassName.replace(exceptionPackage.getName() + ".", "") : fullClassName;
        String exceptionPackageName = exceptionPackage != null ? exceptionPackage.getName() : null;
        SentryStackTrace sentryStackTrace = new SentryStackTrace();
        sentryStackTrace.setFrames(this.sentryStackTraceFactory.getStackFrames(throwable.getStackTrace()));
        if (thread != null) {
            exception.setThreadId(thread.getId());
        }
        exception.setStacktrace(sentryStackTrace);
        exception.setType(exceptionClassName);
        exception.setMechanism(exceptionMechanism);
        exception.setModule(exceptionPackageName);
        exception.setValue(exceptionMessage);
        return exception;
    }

    @NotNull
    Deque<SentryException> extractExceptionQueue(@NotNull Throwable throwable) {
        ArrayDeque<SentryException> exceptions = new ArrayDeque<SentryException>();
        HashSet<Throwable> circularityDetector = new HashSet<Throwable>();
        for (Throwable currentThrowable = throwable; currentThrowable != null && circularityDetector.add(currentThrowable); currentThrowable = currentThrowable.getCause()) {
            Thread thread;
            Mechanism exceptionMechanism;
            if (currentThrowable instanceof ExceptionMechanismException) {
                ExceptionMechanismException exceptionMechanismThrowable = (ExceptionMechanismException)currentThrowable;
                exceptionMechanism = exceptionMechanismThrowable.getExceptionMechanism();
                currentThrowable = exceptionMechanismThrowable.getThrowable();
                thread = exceptionMechanismThrowable.getThread();
            } else {
                exceptionMechanism = null;
                thread = Thread.currentThread();
            }
            SentryException exception = this.getSentryException(currentThrowable, exceptionMechanism, thread);
            exceptions.add(exception);
        }
        return exceptions;
    }
}

