/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.protocol;

import io.sentry.core.protocol.App;
import io.sentry.core.protocol.Browser;
import io.sentry.core.protocol.Device;
import io.sentry.core.protocol.Gpu;
import io.sentry.core.protocol.OperatingSystem;
import io.sentry.core.protocol.SentryRuntime;
import java.util.concurrent.ConcurrentHashMap;

public final class Contexts
extends ConcurrentHashMap<String, Object> {
    private static final long serialVersionUID = 252445813254943011L;

    private <T> T toContextType(String key, Class<T> clazz) {
        Object item = this.get(key);
        return clazz.isInstance(item) ? (T)clazz.cast(item) : null;
    }

    public App getApp() {
        return this.toContextType("app", App.class);
    }

    public void setApp(App app) {
        this.put("app", app);
    }

    public Browser getBrowser() {
        return this.toContextType("browser", Browser.class);
    }

    public void setBrowser(Browser browser) {
        this.put("browser", browser);
    }

    public Device getDevice() {
        return this.toContextType("device", Device.class);
    }

    public void setDevice(Device device) {
        this.put("device", device);
    }

    public OperatingSystem getOperatingSystem() {
        return this.toContextType("os", OperatingSystem.class);
    }

    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.put("os", operatingSystem);
    }

    public SentryRuntime getRuntime() {
        return this.toContextType("runtime", SentryRuntime.class);
    }

    public void setRuntime(SentryRuntime runtime) {
        this.put("runtime", runtime);
    }

    public Gpu getGpu() {
        return this.toContextType("gpu", Gpu.class);
    }

    public void setGpu(Gpu gpu) {
        this.put("gpu", gpu);
    }
}

