/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.transport;

import io.sentry.core.ISerializer;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.transport.IConnectionConfigurator;
import io.sentry.core.transport.ITransport;
import io.sentry.core.transport.TransportResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import javax.net.ssl.SSLSession;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
@ApiStatus.Internal
public class HttpTransport
implements ITransport {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @Nullable
    private final Proxy proxy;
    private final IConnectionConfigurator connectionConfigurator;
    private final ISerializer serializer;
    private final int connectionTimeout;
    private final int readTimeout;
    private final boolean bypassSecurity;
    private final URL sentryUrl;
    private final SentryOptions options;

    public HttpTransport(SentryOptions options, IConnectionConfigurator connectionConfigurator, int connectionTimeoutMills, int readTimeoutMills, boolean bypassSecurity, URL sentryUrl) {
        this.proxy = options.getProxy();
        this.connectionConfigurator = connectionConfigurator;
        this.serializer = options.getSerializer();
        this.connectionTimeout = connectionTimeoutMills;
        this.readTimeout = readTimeoutMills;
        this.options = options;
        this.bypassSecurity = bypassSecurity;
        this.sentryUrl = sentryUrl;
    }

    protected HttpURLConnection open(Proxy proxy) throws IOException {
        return (HttpURLConnection)(proxy == null ? this.sentryUrl.openConnection() : this.sentryUrl.openConnection(proxy));
    }

    /*
     * Exception decompiling
     */
    @Override
    public TransportResult send(SentryEvent event) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logErrorInPayload(HttpURLConnection connection) {
        if (this.options.isDebug()) {
            String errorMessage = null;
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                errorMessage = this.getErrorMessageFromStream(errorStream);
            }
            if (null == errorMessage || errorMessage.isEmpty()) {
                errorMessage = "An exception occurred while submitting the event to the Sentry server.";
            }
            this.options.getLogger().log(SentryLevel.DEBUG, errorMessage, new Object[0]);
        }
    }

    private String getErrorMessageFromStream(InputStream errorStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(line);
                first = false;
            }
        }
        catch (Exception e2) {
            this.options.getLogger().log(SentryLevel.ERROR, "Exception while reading the error message from the connection: " + e2.getMessage(), new Object[0]);
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
    }

    private static /* synthetic */ boolean lambda$send$0(String __, SSLSession ___) {
        return true;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

