/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.Integration;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.UncaughtExceptionHandler;
import io.sentry.core.exception.ExceptionMechanismException;
import io.sentry.core.hints.DiskFlushNotification;
import io.sentry.core.protocol.Mechanism;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class UncaughtExceptionHandlerIntegration
implements Integration,
Thread.UncaughtExceptionHandler,
Closeable {
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private IHub hub;
    private SentryOptions options;
    private boolean registered = false;
    private final UncaughtExceptionHandler threadAdapter;

    UncaughtExceptionHandlerIntegration() {
        this(UncaughtExceptionHandler.Adapter.getInstance());
    }

    UncaughtExceptionHandlerIntegration(UncaughtExceptionHandler threadAdapter) {
        this.threadAdapter = Objects.requireNonNull(threadAdapter, "threadAdapter is required.");
    }

    @Override
    public final void register(IHub hub, SentryOptions options) {
        if (this.registered) {
            options.getLogger().log(SentryLevel.ERROR, "Attempt to register a UncaughtExceptionHandlerIntegration twice.", new Object[0]);
            return;
        }
        this.registered = true;
        this.hub = hub;
        this.options = options;
        Thread.UncaughtExceptionHandler currentHandler = this.threadAdapter.getDefaultUncaughtExceptionHandler();
        if (currentHandler != null) {
            options.getLogger().log(SentryLevel.DEBUG, "default UncaughtExceptionHandler class='" + currentHandler.getClass().getName() + "'", new Object[0]);
            this.defaultExceptionHandler = currentHandler;
        }
        this.threadAdapter.setDefaultUncaughtExceptionHandler(this);
        options.getLogger().log(SentryLevel.DEBUG, "UncaughtExceptionHandlerIntegration installed.", new Object[0]);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable thrown) {
        this.options.getLogger().log(SentryLevel.INFO, "Uncaught exception received.", new Object[0]);
        try {
            UncaughtExceptionHint hint = new UncaughtExceptionHint(this.options.getShutdownTimeout(), this.options.getLogger());
            Throwable throwable = UncaughtExceptionHandlerIntegration.getUnhandledThrowable(thread, thrown);
            SentryEvent event = new SentryEvent(throwable);
            event.setLevel(SentryLevel.FATAL);
            this.hub.captureEvent(event, hint);
            if (!hint.waitFlush()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Timed out waiting to flush event to disk before crashing. Event: %s", event.getEventId());
            }
        }
        catch (Exception e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error sending uncaught exception to Sentry.", e);
        }
        if (this.defaultExceptionHandler != null) {
            this.options.getLogger().log(SentryLevel.INFO, "Invoking inner uncaught exception handler.", new Object[0]);
            this.defaultExceptionHandler.uncaughtException(thread, thrown);
        }
    }

    @NotNull
    static Throwable getUnhandledThrowable(Thread thread, Throwable thrown) {
        Mechanism mechanism = new Mechanism();
        mechanism.setHandled(false);
        mechanism.setType("UncaughtExceptionHandler");
        return new ExceptionMechanismException(mechanism, thrown, thread);
    }

    @Override
    public void close() {
        if (this.defaultExceptionHandler != null && this == this.threadAdapter.getDefaultUncaughtExceptionHandler()) {
            this.threadAdapter.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
        }
    }

    private static final class UncaughtExceptionHint
    implements DiskFlushNotification {
        private final CountDownLatch latch;
        private final long timeoutMills;
        @NotNull
        private final ILogger logger;

        UncaughtExceptionHint(long timeoutMills, @NotNull ILogger logger) {
            this.timeoutMills = timeoutMills;
            this.latch = new CountDownLatch(1);
            this.logger = logger;
        }

        boolean waitFlush() {
            try {
                return this.latch.await(this.timeoutMills, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.log(SentryLevel.ERROR, "Exception while awaiting for flush in UncaughtExceptionHint", e);
                return false;
            }
        }

        @Override
        public void markFlushed() {
            this.latch.countDown();
        }
    }
}

