/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.DirectoryProcessor;
import io.sentry.core.IEnvelopeReader;
import io.sentry.core.IEnvelopeSender;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.ISerializer;
import io.sentry.core.SentryEnvelope;
import io.sentry.core.SentryEnvelopeItem;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.hints.Cached;
import io.sentry.core.hints.Retryable;
import io.sentry.core.hints.SubmissionResult;
import io.sentry.core.util.Objects;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class EnvelopeSender
extends DirectoryProcessor
implements IEnvelopeSender {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final IHub hub;
    private final IEnvelopeReader envelopeReader;
    private final ISerializer serializer;
    @NotNull
    private final ILogger logger;

    public EnvelopeSender(IHub hub, IEnvelopeReader envelopeReader, ISerializer serializer, @NotNull ILogger logger) {
        super(logger);
        this.hub = Objects.requireNonNull(hub, "Hub is required.");
        this.envelopeReader = Objects.requireNonNull(envelopeReader, "Envelope reader is required.");
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required.");
        this.logger = Objects.requireNonNull(logger, "Logger is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFile(@NotNull File file) {
        CachedEnvelopeHint hint = new CachedEnvelopeHint(15000L, this.logger);
        try (FileInputStream stream = new FileInputStream(file);){
            SentryEnvelope envelope = this.envelopeReader.read(stream);
            if (envelope == null) {
                this.logger.log(SentryLevel.ERROR, "Stream from path %s resulted in a null envelope.", file.getAbsolutePath());
            } else {
                this.processEnvelope(envelope, hint);
            }
        }
        catch (IOException e) {
            this.logger.log(SentryLevel.ERROR, "Error processing envelope.", e);
        }
        finally {
            if (file != null && !hint.getRetry()) {
                try {
                    file.delete();
                }
                catch (RuntimeException e) {
                    this.logger.log(SentryLevel.ERROR, "Failed to delete.", e);
                }
            }
        }
    }

    @Override
    protected boolean isRelevantFileName(String fileName) {
        return true;
    }

    @Override
    public void processEnvelopeFile(@NotNull String path) {
        this.processFile(new File(path));
    }

    private void processEnvelope(@NotNull SentryEnvelope envelope, @NotNull CachedEnvelopeHint hint) throws IOException {
        this.logger.log(SentryLevel.DEBUG, "Envelope for event Id: %s", envelope.getHeader().getEventId());
        int items = 0;
        for (SentryEnvelopeItem item : envelope.getItems()) {
            block14: {
                ++items;
                if (item.getHeader() == null) {
                    this.logger.log(SentryLevel.ERROR, "Item %d has no header", items);
                    continue;
                }
                if ("event".equals(item.getHeader().getType())) {
                    InputStreamReader eventReader = new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8);
                    Throwable throwable = null;
                    try {
                        SentryEvent event = this.serializer.deserializeEvent(eventReader);
                        if (event == null) {
                            this.logger.log(SentryLevel.ERROR, "Item %d of type %s returned null by the parser.", items, item.getHeader().getType());
                        } else {
                            if (!envelope.getHeader().getEventId().equals(event.getEventId())) {
                                this.logger.log(SentryLevel.ERROR, "Item %d of has a different event id (%s) to the envelope header (%s)", items, envelope.getHeader().getEventId(), event.getEventId());
                                continue;
                            }
                            this.hub.captureEvent(event, hint);
                            this.logger.log(SentryLevel.DEBUG, "Item %d is being captured.", items);
                            if (!hint.waitFlush()) {
                                this.logger.log(SentryLevel.WARNING, "Timed out waiting for event submission: %s", event.getEventId());
                                break;
                            }
                        }
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        EnvelopeSender.$closeResource(throwable, eventReader);
                        continue;
                    }
                }
                this.logger.log(SentryLevel.WARNING, "Item %d of type: %s ignored.", items, item.getHeader().getType());
            }
            if (!hint.succeeded) {
                this.logger.log(SentryLevel.WARNING, "Envelope for event Id: %s had a failed capture at item %d. No more items will be sent.", envelope.getHeader().getEventId(), items);
                break;
            }
            hint.reset();
        }
    }

    private static final class CachedEnvelopeHint
    implements Cached,
    Retryable,
    SubmissionResult {
        boolean retry = false;
        boolean succeeded = false;
        private CountDownLatch latch;
        private final long timeoutMills;
        @NotNull
        private final ILogger logger;

        CachedEnvelopeHint(long timeoutMills, @NotNull ILogger logger) {
            this.timeoutMills = timeoutMills;
            this.latch = new CountDownLatch(1);
            this.logger = logger;
        }

        boolean waitFlush() {
            try {
                return this.latch.await(this.timeoutMills, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.log(SentryLevel.ERROR, "Exception while awaiting on lock.", e);
                return false;
            }
        }

        public void reset() {
            this.latch = new CountDownLatch(1);
            this.succeeded = false;
        }

        @Override
        public boolean getRetry() {
            return this.retry;
        }

        @Override
        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        @Override
        public void setResult(boolean succeeded) {
            this.succeeded = succeeded;
            this.latch.countDown();
        }
    }
}

