/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import java.io.File;
import org.jetbrains.annotations.NotNull;

abstract class DirectoryProcessor {
    @NotNull
    private final ILogger logger;

    DirectoryProcessor(@NotNull ILogger logger) {
        this.logger = logger;
    }

    void processDirectory(@NotNull File directory) {
        try {
            if (!directory.exists()) {
                this.logger.log(SentryLevel.WARNING, "Directory '%s' doesn't exist. No cached events to send.", directory.getAbsolutePath());
                return;
            }
            if (!directory.isDirectory()) {
                this.logger.log(SentryLevel.ERROR, "Cache dir %s is not a directory.", directory.getAbsolutePath());
                return;
            }
            File[] listFiles = directory.listFiles();
            if (listFiles == null) {
                this.logger.log(SentryLevel.ERROR, "Cache dir %s is null.", directory.getAbsolutePath());
                return;
            }
            File[] filteredListFiles = directory.listFiles((d, name) -> this.isRelevantFileName(name));
            this.logger.log(SentryLevel.DEBUG, "Processing %d items from cache dir %s", filteredListFiles != null ? filteredListFiles.length : 0, directory.getAbsolutePath());
            for (File file : listFiles) {
                this.processFile(file);
            }
        }
        catch (Exception e) {
            this.logger.log(SentryLevel.ERROR, e, "Failed processing '%s'", directory.getAbsolutePath());
        }
    }

    protected abstract void processFile(File var1);

    protected abstract boolean isRelevantFileName(String var1);
}

